/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator.random;

import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.flink.graph.generator.random.GeneratorFactoryBase;
import org.apache.flink.graph.generator.random.RandomGenerable;

public class JDKRandomGeneratorFactory
extends GeneratorFactoryBase<JDKRandomGenerator> {
    public static final long DEFAULT_SEED = 5435701917232523172L;
    public static final int MINIMUM_CYCLES_PER_BLOCK = 0x100000;
    private final JDKRandomGenerator random = new JDKRandomGenerator();

    public JDKRandomGeneratorFactory() {
        this(5435701917232523172L);
    }

    public JDKRandomGeneratorFactory(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    protected int getMinimumCyclesPerBlock() {
        return 0x100000;
    }

    protected JDKRandomGenerable next() {
        return new JDKRandomGenerable(this.random.nextLong());
    }

    private static class JDKRandomGenerable
    implements RandomGenerable<JDKRandomGenerator> {
        private final long seed;

        public JDKRandomGenerable(long seed) {
            this.seed = seed;
        }

        @Override
        public JDKRandomGenerator generator() {
            JDKRandomGenerator random = new JDKRandomGenerator();
            random.setSeed(this.seed);
            return random;
        }
    }
}

