/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.gsa.ApplyFunction;
import org.apache.flink.graph.gsa.GatherFunction;
import org.apache.flink.graph.gsa.Neighbor;
import org.apache.flink.graph.gsa.SumFunction;

public class GSASingleSourceShortestPaths<K, VV>
implements GraphAlgorithm<K, VV, Double, DataSet<Vertex<K, Double>>> {
    private final K srcVertexId;
    private final Integer maxIterations;

    public GSASingleSourceShortestPaths(K srcVertexId, Integer maxIterations) {
        this.srcVertexId = srcVertexId;
        this.maxIterations = maxIterations;
    }

    @Override
    public DataSet<Vertex<K, Double>> run(Graph<K, VV, Double> input) {
        return input.mapVertices(new InitVerticesMapper(this.srcVertexId)).runGatherSumApplyIteration(new CalculateDistances(), new ChooseMinDistance(), new UpdateDistance(), this.maxIterations).getVertices();
    }

    private static final class UpdateDistance<K>
    extends ApplyFunction<K, Double, Double> {
        private UpdateDistance() {
        }

        @Override
        public void apply(Double newDistance, Double oldDistance) {
            if (newDistance < oldDistance) {
                this.setResult(newDistance);
            }
        }
    }

    private static final class ChooseMinDistance
    extends SumFunction<Double, Double, Double> {
        private ChooseMinDistance() {
        }

        @Override
        public Double sum(Double newValue, Double currentValue) {
            return Math.min(newValue, currentValue);
        }
    }

    private static final class CalculateDistances
    extends GatherFunction<Double, Double, Double> {
        private CalculateDistances() {
        }

        @Override
        public Double gather(Neighbor<Double, Double> neighbor) {
            return neighbor.getNeighborValue() + neighbor.getEdgeValue();
        }
    }

    private static final class InitVerticesMapper<K, VV>
    implements MapFunction<Vertex<K, VV>, Double> {
        private K srcVertexId;

        public InitVerticesMapper(K srcId) {
            this.srcVertexId = srcId;
        }

        public Double map(Vertex<K, VV> value) {
            if (value.f0.equals(this.srcVertexId)) {
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
    }
}

