/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.undirected;

import java.math.BigInteger;
import java.text.NumberFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalytic;
import org.apache.flink.graph.GraphAnalyticBase;
import org.apache.flink.graph.asm.dataset.Count;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.library.clustering.undirected.TriangleListing;
import org.apache.flink.graph.library.metric.undirected.VertexMetrics;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.Preconditions;

public class TriadicCensus<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAnalyticBase<K, VV, EV, Result> {
    private Count<TriangleListing.Result<K>> triangleCount;
    private GraphAnalytic<K, VV, EV, VertexMetrics.Result> vertexMetrics;

    public TriadicCensus<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        this.triangleCount = new Count();
        DataSet triangles = (DataSet)input.run(new TriangleListing().setSortTriangleVertices(false).setParallelism(this.parallelism));
        this.triangleCount.run(triangles);
        this.vertexMetrics = new VertexMetrics().setParallelism(this.parallelism);
        input.run(this.vertexMetrics);
        return this;
    }

    @Override
    public Result getResult() {
        BigInteger bigVertexCount = BigInteger.valueOf(this.vertexMetrics.getResult().getNumberOfVertices());
        BigInteger bigEdgeCount = BigInteger.valueOf(this.vertexMetrics.getResult().getNumberOfEdges());
        BigInteger bigTripletCount = BigInteger.valueOf(this.vertexMetrics.getResult().getNumberOfTriplets());
        BigInteger bigTriangleCount = BigInteger.valueOf(this.triangleCount.getResult());
        BigInteger one = BigInteger.ONE;
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger three = BigInteger.valueOf(3L);
        BigInteger six = BigInteger.valueOf(6L);
        BigInteger[] counts = new BigInteger[4];
        counts[3] = bigTriangleCount;
        counts[2] = bigTripletCount.subtract(bigTriangleCount.multiply(three));
        counts[1] = bigEdgeCount.multiply(bigVertexCount.subtract(two)).subtract(counts[2].multiply(two)).subtract(counts[3].multiply(three));
        counts[0] = bigVertexCount.multiply(bigVertexCount.subtract(one)).multiply(bigVertexCount.subtract(two)).divide(six).subtract(counts[1]).subtract(counts[2]).subtract(counts[3]);
        return new Result(counts);
    }

    public static class Result
    implements PrintableResult {
        private final BigInteger[] counts;

        public Result(BigInteger ... counts) {
            Preconditions.checkArgument((counts.length == 4 ? 1 : 0) != 0, (Object)("Expected 4 counts but received " + counts.length));
            this.counts = counts;
        }

        public Result(long ... counts) {
            Preconditions.checkArgument((counts.length == 4 ? 1 : 0) != 0, (Object)("Expected 4 counts but received " + counts.length));
            this.counts = new BigInteger[counts.length];
            for (int i = 0; i < counts.length; ++i) {
                this.counts[i] = BigInteger.valueOf(counts[i]);
            }
        }

        public BigInteger getCount03() {
            return this.counts[0];
        }

        public BigInteger getCount12() {
            return this.counts[1];
        }

        public BigInteger getCount21() {
            return this.counts[2];
        }

        public BigInteger getCount30() {
            return this.counts[3];
        }

        public BigInteger[] getCounts() {
            return this.counts;
        }

        public String toString() {
            return this.toPrintableString();
        }

        @Override
        public String toPrintableString() {
            NumberFormat nf = NumberFormat.getInstance();
            return "03: " + nf.format(this.getCount03()) + "; 12: " + nf.format(this.getCount12()) + "; 21: " + nf.format(this.getCount21()) + "; 30: " + nf.format(this.getCount30());
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object[])this.counts).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append((Object[])this.counts, (Object[])rhs.counts).isEquals();
        }
    }
}

