/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.pregel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.pregel.MessageIterator;
import org.apache.flink.types.Either;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public abstract class ComputeFunction<K, VV, EV, Message>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vertex<K, VV> outVertex;
    private Tuple2<K, Message> outMsg;
    private IterationRuntimeContext runtimeContext;
    private Iterator<Edge<K, EV>> edges;
    private Collector<Either<?, ?>> out;
    private EdgesIterator<K, EV> edgeIterator;
    private boolean edgesUsed;
    private boolean setNewVertexValueCalled;

    public abstract void compute(Vertex<K, VV> var1, MessageIterator<Message> var2) throws Exception;

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public final Iterable<Edge<K, EV>> getEdges() {
        this.verifyEdgeUsage();
        this.edgeIterator.set(this.edges);
        return this.edgeIterator;
    }

    public final void sendMessageToAllNeighbors(Message m) {
        this.verifyEdgeUsage();
        this.outMsg.f1 = m;
        while (this.edges.hasNext()) {
            Tuple next = (Tuple)this.edges.next();
            this.outMsg.f0 = next.getField(1);
            this.out.collect((Object)Either.Right(this.outMsg));
        }
    }

    public final void sendMessageTo(K target, Message m) {
        this.outMsg.f0 = target;
        this.outMsg.f1 = m;
        this.out.collect((Object)Either.Right(this.outMsg));
    }

    public final void setNewVertexValue(VV newValue) {
        if (this.setNewVertexValueCalled) {
            throw new IllegalStateException("setNewVertexValue should only be called at most once per updateVertex");
        }
        this.setNewVertexValueCalled = true;
        this.outVertex.f1 = newValue;
        this.out.collect((Object)Either.Left(this.outVertex));
    }

    public final int getSuperstepNumber() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public final <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public final <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    public final <T> Collection<T> getBroadcastSet(String name) {
        return this.runtimeContext.getBroadcastVariable(name);
    }

    void init(IterationRuntimeContext context) {
        this.runtimeContext = context;
        this.outVertex = new Vertex();
        this.outMsg = new Tuple2();
        this.edgeIterator = new EdgesIterator();
    }

    void set(K vertexId, Iterator<Edge<K, EV>> edges, Collector<Either<Vertex<K, VV>, Tuple2<K, Message>>> out) {
        this.outVertex.f0 = vertexId;
        this.edges = edges;
        this.out = out;
        this.edgesUsed = false;
        this.setNewVertexValueCalled = false;
    }

    private void verifyEdgeUsage() throws IllegalStateException {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getEdges()' or 'sendMessageToAllNeighbors()' exactly once.");
        }
        this.edgesUsed = true;
    }

    private static final class EdgesIterator<K, EV>
    implements Iterator<Edge<K, EV>>,
    Iterable<Edge<K, EV>> {
        private Iterator<Edge<K, EV>> input;
        private Edge<K, EV> edge = new Edge();

        private EdgesIterator() {
        }

        void set(Iterator<Edge<K, EV>> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public Edge<K, EV> next() {
            Edge<K, EV> next = this.input.next();
            this.edge.setSource(next.f0);
            this.edge.setTarget(next.f1);
            this.edge.setValue(next.f2);
            return this.edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Edge<K, EV>> iterator() {
            return this;
        }
    }
}

