/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.CoopLockFsckRunner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Arrays;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configured;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Tool;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.ToolRunner;

public class CoopLockFsck
extends Configured
implements Tool {
    static final String COMMAND_CHECK = "--check";
    static final String COMMAND_ROLL_BACK = "--rollBack";
    static final String COMMAND_ROLL_FORWARD = "--rollForward";
    static final String ARGUMENT_ALL_OPERATIONS = "all";
    private static final ImmutableSet<String> FSCK_COMMANDS = ImmutableSet.of("--check", "--rollForward", "--rollBack");

    public static void main(String[] args) throws Exception {
        Preconditions.checkArgument(args.length > 0, "No arguments are specified");
        if (args.length == 1 && "--help".equals(args[0])) {
            System.out.println("FSCK tool to recover failed directory mutations guarded by GCS Connector Cooperative Locking feature.\n\nUsage:" + String.format("\n\thadoop jar /usr/lib/hadoop/lib/gcs-connector.jar %s --{check,rollBack,rollForward} gs://<bucket_name> [all|<operation_id>]", CoopLockFsck.class.getCanonicalName()) + "\n\nSupported commands:" + String.format("\n\t%s - print out operations status in the bucket", COMMAND_CHECK) + String.format("\n\t%s - recover directory operations in the bucket by rolling them forward", COMMAND_ROLL_FORWARD) + String.format("\n\t%s - recover directory operations in the bucket by rolling them back", COMMAND_ROLL_BACK));
            return;
        }
        int result = ToolRunner.run(new Configuration(), new CoopLockFsck(), args);
        System.exit(result);
    }

    @Override
    public int run(String[] args) throws Exception {
        String command = args[0];
        Preconditions.checkArgument(FSCK_COMMANDS.contains(command), "Unknown %s command, should be %s", (Object)command);
        int expectedArgsNumber = COMMAND_CHECK.equals(command) ? 2 : 3;
        Preconditions.checkArgument(args.length == expectedArgsNumber, "%s arguments should be specified for %s command, but were: %s", (Object)expectedArgsNumber, (Object)command, Arrays.asList(args));
        String bucket = args[1];
        Preconditions.checkArgument(bucket.startsWith("gs://"), "bucket parameter should have 'gs://' scheme");
        String operationId = COMMAND_CHECK.equals(command) ? null : args[2];
        return new CoopLockFsckRunner(this.getConf(), URI.create(bucket), command, operationId).run();
    }
}

