/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.auth;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;

public class DelegationTokenIOException
extends IOException {
    private static final long serialVersionUID = 5431764092856006083L;

    public static DelegationTokenIOException wrongTokenType(Class<? extends DelegationTokenIdentifier> expectedClass, DelegationTokenIdentifier identifier) {
        return new DelegationTokenIOException(String.format("Delegation token type is incorrect; expected a token identifier of type %s but got %s and kind %s", expectedClass, identifier.getClass(), identifier.getKind()));
    }

    public static DelegationTokenIOException tokenMismatch(Text service, Text expectedKind, Text actualKind) {
        return new DelegationTokenIOException(String.format("Token mismatch: expected token for %s of type %s but got a token of type %s", service, expectedKind, actualKind));
    }

    public DelegationTokenIOException(String message) {
        super(message);
    }

    public DelegationTokenIOException(String message, Throwable cause) {
        super(message, cause);
    }
}

