/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.MessageLite;
import io.grpc.KnownLength;

class ZeroCopyReadinessChecker {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final boolean isZeroCopyReady;

    ZeroCopyReadinessChecker() {
    }

    public static boolean isReady() {
        return isZeroCopyReady;
    }

    static {
        boolean detachableClassExists = false;
        try {
            String knownLengthClassName = KnownLength.class.getName();
            String detachableClassName = knownLengthClassName.substring(0, knownLengthClassName.lastIndexOf(46) + 1) + "Detachable";
            Class<?> detachableClass = Class.forName(detachableClassName);
            detachableClassExists = detachableClass != null;
        }
        catch (ClassNotFoundException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(ex)).log("io.grpc.Detachable not found");
        }
        boolean unsafeByteOperationsClassExists = false;
        try {
            String messageLiteClassName = MessageLite.class.getName();
            String unsafeByteOperationsClassName = messageLiteClassName.substring(0, messageLiteClassName.lastIndexOf(46) + 1) + "UnsafeByteOperations";
            Class<?> unsafeByteOperationsClass = Class.forName(unsafeByteOperationsClassName);
            unsafeByteOperationsClassExists = unsafeByteOperationsClass != null;
        }
        catch (ClassNotFoundException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(ex)).log("com.google.protobuf.UnsafeByteOperations not found");
        }
        isZeroCopyReady = detachableClassExists && unsafeByteOperationsClassExists;
    }
}

