/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.storage.Storage;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.fs.gs.storage.GSBlobStorageImpl;
import org.apache.flink.fs.gs.writer.GSRecoverableWriter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSFileSystem
extends HadoopFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSFileSystem.class);
    private final GSFileSystemOptions fileSystemOptions;
    private final Storage storage;

    GSFileSystem(GoogleHadoopFileSystem googleHadoopFileSystem, Storage storage, GSFileSystemOptions fileSystemOptions) {
        super((FileSystem)Preconditions.checkNotNull((Object)googleHadoopFileSystem));
        this.fileSystemOptions = (GSFileSystemOptions)Preconditions.checkNotNull((Object)fileSystemOptions);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
    }

    @Override
    public RecoverableWriter createRecoverableWriter() {
        LOGGER.info("Creating GSRecoverableWriter with file-system options {}", (Object)this.fileSystemOptions);
        GSBlobStorageImpl blobStorage = new GSBlobStorageImpl(this.storage);
        return new GSRecoverableWriter(blobStorage, this.fileSystemOptions);
    }
}

