/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup;

import java.util.ResourceBundle;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class ResourceBundleStringLookup
extends AbstractStringLookup {
    static final ResourceBundleStringLookup INSTANCE = new ResourceBundleStringLookup();

    private ResourceBundleStringLookup() {
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        String[] keys = key.split(":");
        int keyLen = keys.length;
        if (keyLen != 2) {
            throw IllegalArgumentExceptions.format("Bad ResourceBundle key format [%s]. Expected format is BundleName:KeyName.", key);
        }
        String bundleName = keys[0];
        String bundleKey = keys[1];
        try {
            return ResourceBundle.getBundle(bundleName).getString(bundleKey);
        }
        catch (Exception e) {
            throw IllegalArgumentExceptions.format(e, "Error looking up ResourceBundle [%s] and key [%s].", bundleName, bundleKey);
        }
    }
}

