/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSBuilder;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.functional.FutureIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FutureIOSupport {
    private FutureIOSupport() {
    }

    public static <T> T awaitFuture(Future<T> future) throws InterruptedIOException, IOException, RuntimeException {
        return FutureIO.awaitFuture(future);
    }

    public static <T> T awaitFuture(Future<T> future, long timeout, TimeUnit unit) throws InterruptedIOException, IOException, RuntimeException, TimeoutException {
        return FutureIO.awaitFuture(future, timeout, unit);
    }

    public static <T> T raiseInnerCause(ExecutionException e) throws IOException {
        return FutureIO.raiseInnerCause(e);
    }

    public static <T> T raiseInnerCause(CompletionException e) throws IOException {
        return FutureIO.raiseInnerCause(e);
    }

    public static <T, U extends FSBuilder<T, U>> FSBuilder<T, U> propagateOptions(FSBuilder<T, U> builder, Configuration conf, String optionalPrefix, String mandatoryPrefix) {
        FutureIOSupport.propagateOptions(builder, conf, optionalPrefix, false);
        FutureIOSupport.propagateOptions(builder, conf, mandatoryPrefix, true);
        return builder;
    }

    public static void propagateOptions(FSBuilder<?, ?> builder, Configuration conf, String prefix, boolean mandatory) {
        String p = prefix.endsWith(".") ? prefix : prefix + ".";
        Map<String, String> propsWithPrefix = conf.getPropsWithPrefix(p);
        for (Map.Entry<String, String> entry : propsWithPrefix.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (mandatory) {
                builder.must(key, val);
                continue;
            }
            builder.opt(key, val);
        }
    }

    public static <T> CompletableFuture<T> eval(CallableRaisingIOE<T> callable) {
        CompletableFuture<T> result = new CompletableFuture<T>();
        try {
            result.complete(callable.apply());
        }
        catch (IllegalArgumentException | UnsupportedOperationException tx) {
            throw tx;
        }
        catch (Throwable tx) {
            result.completeExceptionally(tx);
        }
        return result;
    }
}

