/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.StreamCapabilities;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Syncable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatisticsSupport;

public class BufferedIOStatisticsOutputStream
extends BufferedOutputStream
implements IOStatisticsSource,
Syncable,
StreamCapabilities {
    private final boolean downgradeSyncable;

    public BufferedIOStatisticsOutputStream(OutputStream out, boolean downgradeSyncable) {
        super(out);
        this.downgradeSyncable = downgradeSyncable;
    }

    public BufferedIOStatisticsOutputStream(OutputStream out, int size, boolean downgradeSyncable) {
        super(out, size);
        this.downgradeSyncable = downgradeSyncable;
    }

    @Override
    public IOStatistics getIOStatistics() {
        return IOStatisticsSupport.retrieveIOStatistics(this.out);
    }

    @Override
    public boolean hasCapability(String capability) {
        if (this.out instanceof StreamCapabilities) {
            return ((StreamCapabilities)((Object)this.out)).hasCapability(capability);
        }
        return false;
    }

    @Override
    public void hflush() throws IOException {
        if (this.out instanceof Syncable) {
            this.flush();
            ((Syncable)((Object)this.out)).hflush();
        } else {
            if (!this.downgradeSyncable) {
                throw new UnsupportedOperationException("hflush not supported by " + this.out);
            }
            this.flush();
        }
    }

    @Override
    public void hsync() throws IOException {
        if (this.out instanceof Syncable) {
            this.flush();
            ((Syncable)((Object)this.out)).hsync();
        } else {
            if (!this.downgradeSyncable) {
                throw new UnsupportedOperationException("hsync not supported by " + this.out);
            }
            this.flush();
        }
    }
}

