/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.NestedNonSerializableMapCreator;
import org.apache.flink.api.java.functions.NestedSerializableMapCreator;
import org.apache.flink.api.java.functions.NonSerializableMapCreator;
import org.apache.flink.api.java.functions.SerializableMapCreator;
import org.junit.Assert;
import org.junit.Test;

public class ClosureCleanerTest {
    @Test(expected=InvalidProgramException.class)
    public void testNonSerializable() throws Exception {
        NonSerializableMapCreator creator = new NonSerializableMapCreator();
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.ensureSerializable(map);
        int result = (Integer)map.map((Object)3);
        Assert.assertEquals((long)result, (long)4L);
    }

    @Test
    public void testCleanedNonSerializable() throws Exception {
        NonSerializableMapCreator creator = new NonSerializableMapCreator();
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (boolean)true);
        int result = (Integer)map.map((Object)3);
        Assert.assertEquals((long)result, (long)4L);
    }

    @Test
    public void testSerializable() throws Exception {
        SerializableMapCreator creator = new SerializableMapCreator(1);
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (boolean)true);
        int result = (Integer)map.map((Object)3);
        Assert.assertEquals((long)result, (long)4L);
    }

    @Test
    public void testNestedSerializable() throws Exception {
        NestedSerializableMapCreator creator = new NestedSerializableMapCreator(1);
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (boolean)true);
        ClosureCleaner.ensureSerializable(map);
        int result = (Integer)map.map((Object)3);
        Assert.assertEquals((long)result, (long)4L);
    }

    @Test(expected=InvalidProgramException.class)
    public void testNestedNonSerializable() throws Exception {
        NestedNonSerializableMapCreator creator = new NestedNonSerializableMapCreator(1);
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (boolean)true);
        ClosureCleaner.ensureSerializable(map);
        int result = (Integer)map.map((Object)3);
        Assert.assertEquals((long)result, (long)4L);
    }
}

