/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvOutputFormatTest {
    private String path = null;

    @Before
    public void createFile() throws Exception {
        this.path = File.createTempFile("csv_output_test_file", ".csv").getAbsolutePath();
    }

    @Test
    public void testNullAllow() throws Exception {
        try (CsvOutputFormat csvOutputFormat = new CsvOutputFormat(new Path(this.path));){
            csvOutputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
            csvOutputFormat.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
            csvOutputFormat.setAllowNullValues(true);
            csvOutputFormat.open(0, 1);
            csvOutputFormat.writeRecord((Tuple)new Tuple3((Object)"One", null, (Object)8));
        }
        java.nio.file.Path p = Paths.get(this.path, new String[0]);
        Assert.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
        List<String> lines = Files.readAllLines(Paths.get(this.path, new String[0]), StandardCharsets.UTF_8);
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertEquals((Object)"One,,8", (Object)lines.get(0));
    }

    @Test
    public void testNullDisallowOnDefault() throws Exception {
        try (CsvOutputFormat csvOutputFormat = new CsvOutputFormat(new Path(this.path));){
            csvOutputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
            csvOutputFormat.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
            csvOutputFormat.open(0, 1);
            try {
                csvOutputFormat.writeRecord((Tuple)new Tuple3((Object)"One", null, (Object)8));
                Assert.fail((String)"should fail with an exception");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @After
    public void cleanUp() throws IOException {
        Files.deleteIfExists(Paths.get(this.path, new String[0]));
    }
}

