/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Test;

public class FullOuterJoinOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test
    public void testFullOuter1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{4}).with((JoinFunction)new DummyJoin());
    }

    @Test
    public void testFullOuter2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new String[]{"f1"}).equalTo(new String[]{"f3"}).with((JoinFunction)new DummyJoin());
    }

    @Test
    public void testFullOuter3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where((KeySelector)new IntKeySelector()).equalTo((KeySelector)new IntKeySelector()).with((JoinFunction)new DummyJoin());
    }

    @Test
    public void testFullOuter4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new int[]{0}).equalTo((KeySelector)new IntKeySelector()).with((JoinFunction)new DummyJoin());
    }

    @Test
    public void testFullOuter5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where((KeySelector)new IntKeySelector()).equalTo(new String[]{"f4"}).with((JoinFunction)new DummyJoin());
    }

    @Test
    public void testFullOuter6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new String[]{"f0"}).equalTo(new int[]{4}).with((JoinFunction)new DummyJoin());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testFullOuter7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new int[]{5}).equalTo(new int[]{0}).with((JoinFunction)new DummyJoin());
    }

    @Test(expected=CompositeType.InvalidFieldReferenceException.class)
    public void testFullOuter8() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new int[]{1}).equalTo(new String[]{"f5"}).with((JoinFunction)new DummyJoin());
    }

    @Test(expected=InvalidProgramException.class)
    public void testFullOuter9() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{1}).with((JoinFunction)new DummyJoin());
    }

    @Test(expected=InvalidProgramException.class)
    public void testFullOuter10() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2).where((KeySelector)new IntKeySelector()).equalTo((KeySelector)new LongKeySelector()).with((JoinFunction)new DummyJoin());
    }

    @Test
    public void testFullOuterStrategy1() {
        this.testFullOuterStrategies(JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    @Test
    public void testFullOuterStrategy2() {
        this.testFullOuterStrategies(JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE);
    }

    @Test
    public void testFullOuterStrategy3() {
        this.testFullOuterStrategies(JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND);
    }

    @Test(expected=InvalidProgramException.class)
    public void testFullOuterStrategy4() {
        this.testFullOuterStrategies(JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
    }

    @Test
    public void testFullOuterStrategy5() {
        this.testFullOuterStrategies(JoinOperatorBase.JoinHint.REPARTITION_HASH_FIRST);
    }

    @Test(expected=InvalidProgramException.class)
    public void testFullOuterStrategy6() {
        this.testFullOuterStrategies(JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    private void testFullOuterStrategies(JoinOperatorBase.JoinHint hint) {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.fullOuterJoin((DataSet)ds2, hint).where(new int[]{0}).equalTo(new int[]{4}).with((JoinFunction)new DummyJoin());
    }

    private static class LongKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Long> {
        private LongKeySelector() {
        }

        public Long getKey(Tuple5<Integer, Long, String, Long, Integer> v) throws Exception {
            return (Long)v.f1;
        }
    }

    private static class IntKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Integer> {
        private IntKeySelector() {
        }

        public Integer getKey(Tuple5<Integer, Long, String, Long, Integer> v) throws Exception {
            return (Integer)v.f0;
        }
    }

    private static class DummyJoin
    implements JoinFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Long> {
        private DummyJoin() {
        }

        public Long join(Tuple5<Integer, Long, String, Long, Integer> v1, Tuple5<Integer, Long, String, Long, Integer> v2) throws Exception {
            return 1L;
        }
    }
}

