/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.lang.reflect.Method;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class OperatorTest {
    @Test
    public void testConfigurationOfParallelism() {
        MockOperator operator = new MockOperator();
        int parallelism = 36;
        operator.setParallelism(parallelism);
        Assert.assertEquals((long)parallelism, (long)operator.getParallelism());
        parallelism = -1;
        operator.setParallelism(parallelism);
        Assert.assertEquals((long)parallelism, (long)operator.getParallelism());
    }

    @Test
    public void testConfigurationOfResource() throws Exception {
        MockOperator operator = new MockOperator();
        Method opMethod = Operator.class.getDeclaredMethod("setResources", ResourceSpec.class, ResourceSpec.class);
        opMethod.setAccessible(true);
        ResourceSpec minResources = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).build();
        ResourceSpec preferredResources = ResourceSpec.newBuilder().setCpuCores(2.0).setHeapMemoryInMB(200).build();
        opMethod.invoke((Object)operator, minResources, preferredResources);
        Assert.assertEquals((Object)minResources, (Object)operator.getMinResources());
        Assert.assertEquals((Object)preferredResources, (Object)operator.getPreferredResources());
    }

    private class MockOperator
    extends Operator {
        public MockOperator() {
            super((ExecutionEnvironment)ExecutionEnvironment.createCollectionsEnvironment(), (TypeInformation)ValueTypeInfo.NULL_VALUE_TYPE_INFO);
        }
    }
}

