/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.junit.Test;

public class PartitionOperatorTest {
    private DataSet<Tuple2<Integer, String>> getTupleDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1, (Object)"first"), new Tuple2((Object)2, (Object)"second"), new Tuple2((Object)3, (Object)"third"), new Tuple2((Object)4, (Object)"fourth"), new Tuple2((Object)5, (Object)"fifth"), new Tuple2((Object)6, (Object)"sixth")});
    }

    private DataSet<CustomPojo> getPojoDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new CustomPojo[]{new CustomPojo(1, "first"), new CustomPojo(2, "second"), new CustomPojo(3, "third"), new CustomPojo(4, "fourth"), new CustomPojo(5, "fifth"), new CustomPojo(6, "sixth")});
    }

    private DataSet<NestedPojo> getNestedPojoDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new NestedPojo[]{new NestedPojo(new CustomPojo(1, "first"), 1L), new NestedPojo(new CustomPojo(2, "second"), 2L), new NestedPojo(new CustomPojo(3, "third"), 3L), new NestedPojo(new CustomPojo(4, "fourth"), 4L), new NestedPojo(new CustomPojo(5, "fifth"), 5L), new NestedPojo(new CustomPojo(6, "sixth"), 6L)});
    }

    @Test
    public void testRebalance() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.rebalance();
    }

    @Test
    public void testHashPartitionByField1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByHash(new int[]{0});
    }

    @Test
    public void testHashPartitionByField2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByHash(new int[]{0, 1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testHashPartitionByFieldOutOfRange() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByHash(new int[]{0, 1, 2});
    }

    @Test
    public void testHashPartitionByFieldName1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByHash(new String[]{"number"});
    }

    @Test
    public void testHashPartitionByFieldName2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByHash(new String[]{"number", "name"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHashPartitionByInvalidFieldName() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByHash(new String[]{"number", "name", "invalidField"});
    }

    @Test
    public void testRangePartitionByFieldName1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByRange(new String[]{"number"});
    }

    @Test
    public void testRangePartitionByFieldName2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByRange(new String[]{"number", "name"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangePartitionByInvalidFieldName() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionByRange(new String[]{"number", "name", "invalidField"});
    }

    @Test
    public void testRangePartitionByField1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0});
    }

    @Test
    public void testRangePartitionByField2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0, 1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangePartitionWithEmptyIndicesKey() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2((Object)1, (Object)1), (Object)1), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2)});
        ds.partitionByRange(new int[0]);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRangePartitionByFieldOutOfRange() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0, 1, 2});
    }

    @Test(expected=IllegalStateException.class)
    public void testHashPartitionWithOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByHash(new int[]{1}).withOrders(new Order[]{Order.ASCENDING});
    }

    @Test(expected=IllegalStateException.class)
    public void testRebalanceWithOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.rebalance().withOrders(new Order[]{Order.ASCENDING});
    }

    @Test
    public void testRangePartitionWithOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0}).withOrders(new Order[]{Order.ASCENDING});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangePartitionWithTooManyOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionByRange(new int[]{0}).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING});
    }

    @Test
    public void testRangePartitionByComplexKeyWithOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2((Object)1, (Object)1), (Object)1), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2)});
        ds.partitionByRange(new int[]{0, 1}).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangePartitionByComplexKeyWithTooManyOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2((Object)1, (Object)1), (Object)1), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2), new Tuple2((Object)new Tuple2((Object)2, (Object)2), (Object)2)});
        ds.partitionByRange(new int[]{0}).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING});
    }

    @Test
    public void testRangePartitionBySelectorComplexKeyWithOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<NestedPojo> ds = this.getNestedPojoDataSet(env);
        ds.partitionByRange((KeySelector)new KeySelector<NestedPojo, CustomPojo>(){

            public CustomPojo getKey(NestedPojo value) throws Exception {
                return value.getNested();
            }
        }).withOrders(new Order[]{Order.ASCENDING});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangePartitionBySelectorComplexKeyWithTooManyOrders() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<NestedPojo> ds = this.getNestedPojoDataSet(env);
        ds.partitionByRange((KeySelector)new KeySelector<NestedPojo, CustomPojo>(){

            public CustomPojo getKey(NestedPojo value) throws Exception {
                return value.getNested();
            }
        }).withOrders(new Order[]{Order.ASCENDING, Order.DESCENDING});
    }

    @Test
    public void testRangePartitionCustomPartitionerByFieldId() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionCustom((Partitioner)new Partitioner<Integer>(){

            public int partition(Integer key, int numPartitions) {
                return 1;
            }
        }, 0);
    }

    @Test(expected=InvalidProgramException.class)
    public void testRangePartitionInvalidCustomPartitionerByFieldId() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple2<Integer, String>> ds = this.getTupleDataSet(env);
        ds.partitionCustom((Partitioner)new Partitioner<Integer>(){

            public int partition(Integer key, int numPartitions) {
                return 1;
            }
        }, 1);
    }

    @Test
    public void testRangePartitionCustomPartitionerByFieldName() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionCustom((Partitioner)new Partitioner<Integer>(){

            public int partition(Integer key, int numPartitions) {
                return 1;
            }
        }, "number");
    }

    @Test(expected=InvalidProgramException.class)
    public void testRangePartitionInvalidCustomPartitionerByFieldName() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionCustom((Partitioner)new Partitioner<Integer>(){

            public int partition(Integer key, int numPartitions) {
                return 1;
            }
        }, "name");
    }

    @Test
    public void testRangePartitionCustomPartitionerByKeySelector() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CustomPojo> ds = this.getPojoDataSet(env);
        ds.partitionCustom((Partitioner)new Partitioner<Integer>(){

            public int partition(Integer key, int numPartitions) {
                return 1;
            }
        }, (KeySelector)new KeySelector<CustomPojo, Integer>(){

            public Integer getKey(CustomPojo value) throws Exception {
                return value.getNumber();
            }
        });
    }

    public static class NestedPojo
    implements Serializable {
        private CustomPojo nested;
        private Long outer;

        public NestedPojo() {
        }

        public NestedPojo(CustomPojo nested, Long outer) {
            this.nested = nested;
            this.outer = outer;
        }

        public CustomPojo getNested() {
            return this.nested;
        }

        public void setNested(CustomPojo nested) {
            this.nested = nested;
        }

        public Long getOuter() {
            return this.outer;
        }

        public void setOuter(Long outer) {
            this.outer = outer;
        }
    }

    public static class CustomPojo
    implements Serializable,
    Comparable<CustomPojo> {
        private Integer number;
        private String name;

        public CustomPojo() {
        }

        public CustomPojo(Integer number, String name) {
            this.number = number;
            this.name = name;
        }

        public Integer getNumber() {
            return this.number;
        }

        public void setNumber(Integer number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(CustomPojo o) {
            return Integer.compare(this.number, o.number);
        }
    }
}

