/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;

public abstract class AggregateCombineHarness<T, R, A extends Aggregator<T, R>> {
    protected abstract void compareResults(R var1, R var2);

    @SafeVarargs
    public final R summarize(T ... values) {
        if (values.length == 0) {
            A agg1 = this.initAggregator();
            agg1.combine(this.initAggregator());
            return (R)agg1.result();
        }
        Object previousResult = null;
        Object result = null;
        List<T> list = Arrays.asList(values);
        Collections.shuffle(list);
        for (int i = 0; i < values.length; ++i) {
            int j;
            A aggregator1 = this.initAggregator();
            A aggregator2 = this.initAggregator();
            for (j = 0; j < i; ++j) {
                aggregator1.aggregate(list.get(j));
            }
            for (j = i; j < values.length; ++j) {
                aggregator2.aggregate(list.get(j));
            }
            aggregator1.combine(aggregator2);
            previousResult = result;
            result = aggregator1.result();
            if (previousResult == null) continue;
            this.compareResults(result, previousResult);
        }
        return (R)result;
    }

    private A initAggregator() {
        try {
            return (A)((Aggregator)((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2]).newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize aggregator", e);
        }
    }
}

