/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.aggregation.CompensatedSum;
import org.junit.Assert;
import org.junit.Test;

public class CompensatedSumTest {
    @Test
    public void testAdd1() throws Exception {
        CompensatedSum smallSum = new CompensatedSum(0.001, 0.0);
        CompensatedSum largeSum = new CompensatedSum(1000.0, 0.0);
        CompensatedSum compensatedResult1 = smallSum;
        CompensatedSum compensatedResult2 = largeSum;
        double naiveResult1 = smallSum.value();
        double naiveResult2 = largeSum.value();
        for (int i = 0; i < 10; ++i) {
            compensatedResult1 = compensatedResult1.add(smallSum);
            compensatedResult2 = compensatedResult2.add(smallSum);
            naiveResult1 += smallSum.value();
            naiveResult2 += smallSum.value();
        }
        compensatedResult1 = compensatedResult1.add(largeSum);
        compensatedResult2 = compensatedResult2.add(smallSum);
        Assert.assertEquals((double)1000.011, (double)compensatedResult1.value(), (double)0.0);
        Assert.assertEquals((double)1000.011, (double)compensatedResult2.value(), (double)0.0);
        Assert.assertEquals((double)1000.011, (double)(naiveResult1 += largeSum.value()), (double)0.0);
        Assert.assertEquals((double)1000.0109999999997, (double)(naiveResult2 += smallSum.value()), (double)0.0);
        Assert.assertEquals((double)compensatedResult1.value(), (double)compensatedResult2.value(), (double)0.0);
        Assert.assertEquals((double)naiveResult1, (double)naiveResult2, (double)1.0E-4);
        Assert.assertNotEquals((double)naiveResult1, (double)naiveResult2, (double)0.0);
    }

    @Test
    public void testDelta() throws Exception {
        CompensatedSum compensatedResult1 = new CompensatedSum(0.001, 0.0);
        for (int i = 0; i < 10; ++i) {
            compensatedResult1 = compensatedResult1.add(0.001);
        }
        Assert.assertEquals((double)0.011, (double)compensatedResult1.value(), (double)0.0);
        Assert.assertEquals((double)new Double("8.673617379884035E-19"), (double)compensatedResult1.delta(), (double)0.0);
    }
}

