/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.DoubleSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.DoubleValue;
import org.junit.Assert;

public class DoubleValueSummaryAggregatorTest
extends DoubleSummaryAggregatorTest {
    @Override
    protected NumericColumnSummary<Double> summarize(Double ... values) {
        DoubleValue[] doubleValues = new DoubleValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            doubleValues[i] = new DoubleValue(values[i].doubleValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<DoubleValue, NumericColumnSummary<Double>, ValueSummaryAggregator.DoubleValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Double> result1, NumericColumnSummary<Double> result2) {
                Assert.assertEquals((double)((Double)result1.getMin()), (double)((Double)result2.getMin()), (double)0.0);
                Assert.assertEquals((double)((Double)result1.getMax()), (double)((Double)result2.getMax()), (double)0.0);
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(doubleValues);
    }
}

