/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.utils.AbstractParameterToolTest;
import org.apache.flink.api.java.utils.ParameterTool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParameterToolTest
extends AbstractParameterToolTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testThrowExceptionIfParameterIsNotPrefixed() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Error parsing arguments '[a]' on 'a'. Please prefix keys with -- or -.");
        ParameterTool.fromArgs((String[])new String[]{"a"});
    }

    @Test
    public void testNoVal() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-berlin"});
        Assert.assertEquals((long)1L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("berlin"));
    }

    @Test
    public void testNoValDouble() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin"});
        Assert.assertEquals((long)1L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("berlin"));
    }

    @Test
    public void testMultipleNoVal() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--a", "--b", "--c", "--d", "--e", "--f"});
        Assert.assertEquals((long)6L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
        Assert.assertTrue((boolean)parameter.has("c"));
        Assert.assertTrue((boolean)parameter.has("d"));
        Assert.assertTrue((boolean)parameter.has("e"));
        Assert.assertTrue((boolean)parameter.has("f"));
    }

    @Test
    public void testMultipleNoValMixed() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--a", "-b", "-c", "-d", "--e", "--f"});
        Assert.assertEquals((long)6L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
        Assert.assertTrue((boolean)parameter.has("c"));
        Assert.assertTrue((boolean)parameter.has("d"));
        Assert.assertTrue((boolean)parameter.has("e"));
        Assert.assertTrue((boolean)parameter.has("f"));
    }

    @Test
    public void testEmptyVal() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The input [--a, -b, --] contains an empty argument");
        ParameterTool.fromArgs((String[])new String[]{"--a", "-b", "--"});
    }

    @Test
    public void testEmptyValShort() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The input [--a, -b, -] contains an empty argument");
        ParameterTool.fromArgs((String[])new String[]{"--a", "-b", "-"});
    }

    @Test
    public void testFromCliArgs() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--input", "myInput", "-expectedCount", "15", "--withoutValues", "--negativeFloat", "-0.58", "-isWorking", "true", "--maxByte", "127", "-negativeShort", "-1024"});
        Assert.assertEquals((long)7L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
        Assert.assertTrue((boolean)parameter.has("withoutValues"));
        Assert.assertEquals((double)-0.58, (double)parameter.getFloat("negativeFloat"), (double)0.1);
        Assert.assertTrue((boolean)parameter.getBoolean("isWorking"));
        Assert.assertEquals((long)127L, (long)parameter.getByte("maxByte"));
        Assert.assertEquals((long)-1024L, (long)parameter.getShort("negativeShort"));
    }

    @Test
    public void testFromPropertiesFile() throws IOException {
        File propertiesFile = this.tmp.newFile();
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        try (FileOutputStream out = new FileOutputStream(propertiesFile);){
            props.store(out, "Test properties");
        }
        ParameterTool parameter = ParameterTool.fromPropertiesFile((String)propertiesFile.getAbsolutePath());
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
        parameter = ParameterTool.fromPropertiesFile((File)propertiesFile);
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            parameter = ParameterTool.fromPropertiesFile((InputStream)fis);
        }
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
    }

    @Test
    public void testFromMapOrProperties() {
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromMap((Map)props);
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
    }

    @Test
    public void testSystemProperties() {
        System.setProperty("input", "myInput");
        System.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromSystemProperties();
        this.validate(parameter);
    }

    @Test
    public void testMerged() {
        ParameterTool parameter1 = ParameterTool.fromArgs((String[])new String[]{"--input", "myInput"});
        System.setProperty("expectedCount", "15");
        ParameterTool parameter2 = ParameterTool.fromSystemProperties();
        ParameterTool parameter = parameter1.mergeWith(parameter2);
        this.validate(parameter);
    }

    @Test
    public void testUnrequestedBoolean() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-boolean", "true"});
        Assert.assertEquals(ParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedBooleanWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-boolean", "true"});
        Assert.assertEquals(ParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean", false));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean", false));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedBooleanWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-boolean"});
        Assert.assertEquals(ParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        parameter.getBoolean("boolean");
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedByte() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-byte", "1"});
        Assert.assertEquals(ParameterToolTest.createHashSet("byte"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedByteWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-byte", "1"});
        Assert.assertEquals(ParameterToolTest.createHashSet("byte"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte", (byte)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte", (byte)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedByteWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-byte"});
        Assert.assertEquals(ParameterToolTest.createHashSet("byte"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getByte("byte");
    }

    @Test
    public void testUnrequestedShort() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-short", "2"});
        Assert.assertEquals(ParameterToolTest.createHashSet("short"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedShortWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-short", "2"});
        Assert.assertEquals(ParameterToolTest.createHashSet("short"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short", (short)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short", (short)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedShortWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-short"});
        Assert.assertEquals(ParameterToolTest.createHashSet("short"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getShort("short");
    }

    @Test
    public void testUnrequestedInt() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-int", "4"});
        Assert.assertEquals(ParameterToolTest.createHashSet("int"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedIntWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-int", "4"});
        Assert.assertEquals(ParameterToolTest.createHashSet("int"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int", 0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int", 0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedIntWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-int"});
        Assert.assertEquals(ParameterToolTest.createHashSet("int"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getInt("int");
    }

    @Test
    public void testUnrequestedLong() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-long", "8"});
        Assert.assertEquals(ParameterToolTest.createHashSet("long"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedLongWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-long", "8"});
        Assert.assertEquals(ParameterToolTest.createHashSet("long"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long", 0L));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long", 0L));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedLongWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-long"});
        Assert.assertEquals(ParameterToolTest.createHashSet("long"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getLong("long");
    }

    @Test
    public void testUnrequestedFloat() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-float", "4"});
        Assert.assertEquals(ParameterToolTest.createHashSet("float"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedFloatWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-float", "4"});
        Assert.assertEquals(ParameterToolTest.createHashSet("float"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float", 0.0f), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float", 0.0f), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedFloatWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-float"});
        Assert.assertEquals(ParameterToolTest.createHashSet("float"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getFloat("float");
    }

    @Test
    public void testUnrequestedDouble() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-double", "8"});
        Assert.assertEquals(ParameterToolTest.createHashSet("double"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedDoubleWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-double", "8"});
        Assert.assertEquals(ParameterToolTest.createHashSet("double"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double", 0.0), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double", 0.0), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedDoubleWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-double"});
        Assert.assertEquals(ParameterToolTest.createHashSet("double"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getDouble("double");
    }

    @Test
    public void testUnrequestedString() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-string", "\u221e"});
        Assert.assertEquals(ParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedStringWithDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-string", "\u221e"});
        Assert.assertEquals(ParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string", "0.0"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string", "0.0"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedStringWithMissingValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-string"});
        Assert.assertEquals(ParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        parameter.get("string");
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedHas() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-boolean"});
        Assert.assertEquals(ParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.has("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.has("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedRequired() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-required", "\u221e"});
        Assert.assertEquals(ParameterToolTest.createHashSet("required"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.getRequired("required"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.getRequired("required"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedMultiple() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-boolean", "true", "-byte", "1", "-short", "2", "-int", "4", "-long", "8", "-float", "4.0", "-double", "8.0", "-string", "\u221e"});
        Assert.assertEquals(ParameterToolTest.createHashSet("boolean", "byte", "short", "int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean"));
        Assert.assertEquals(ParameterToolTest.createHashSet("byte", "short", "int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte"));
        Assert.assertEquals(ParameterToolTest.createHashSet("short", "int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short"));
        Assert.assertEquals(ParameterToolTest.createHashSet("int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int"));
        Assert.assertEquals(ParameterToolTest.createHashSet("long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long"));
        Assert.assertEquals(ParameterToolTest.createHashSet("float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float"), (double)1.0E-5);
        Assert.assertEquals(ParameterToolTest.createHashSet("double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double"), (double)1.0E-5);
        Assert.assertEquals(ParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedUnknown() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[0]);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean", true));
        Assert.assertEquals((long)0L, (long)parameter.getByte("byte", (byte)0));
        Assert.assertEquals((long)0L, (long)parameter.getShort("short", (short)0));
        Assert.assertEquals((long)0L, (long)parameter.getInt("int", 0));
        Assert.assertEquals((long)0L, (long)parameter.getLong("long", 0L));
        Assert.assertEquals((double)0.0, (double)parameter.getFloat("float", 0.0f), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)parameter.getDouble("double", 0.0), (double)1.0E-5);
        Assert.assertEquals((Object)"0", (Object)parameter.get("string", "0"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentExecutionConfigSerialization() throws ExecutionException, InterruptedException {
        int numInputs = 10;
        ArrayList<String> input = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            input.add("--" + UUID.randomUUID());
            input.add(UUID.randomUUID().toString());
        }
        String[] args = input.toArray(new String[0]);
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        int numThreads = 5;
        int numSerializations = 100;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(100);
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        try {
            for (int i = 0; i < 100; ++i) {
                futures.add(CompletableFuture.runAsync(() -> {
                    try {
                        this.serializeDeserialize(parameterTool);
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, executorService));
            }
            for (CompletableFuture completableFuture : futures) {
                completableFuture.get();
            }
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void serializeDeserialize(ParameterTool parameterTool) throws IOException, ClassNotFoundException {
        parameterTool.get(UUID.randomUUID().toString());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(parameterTool);
            oos.close();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            ParameterTool parameterTool2 = (ParameterTool)ois.readObject();
        }
    }

    private static <T> Set<T> createHashSet(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }
}

