/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.KubernetesJobManagerSpecification;
import org.apache.flink.kubernetes.kubeclient.decorators.CmdJobManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.EnvSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.ExternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.FlinkConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.HadoopConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InitJobManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KerberosMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.MountSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.PodTemplateMountDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesOwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.OwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class KubernetesJobManagerFactory {
    public static KubernetesJobManagerSpecification buildKubernetesJobManagerSpecification(FlinkPod podTemplate, KubernetesJobManagerParameters kubernetesJobManagerParameters) throws IOException {
        KubernetesStepDecorator[] stepDecorators;
        FlinkPod flinkPod = ((FlinkPod)Preconditions.checkNotNull((Object)podTemplate)).copy();
        ArrayList<HasMetadata> accompanyingResources = new ArrayList<HasMetadata>();
        for (KubernetesStepDecorator stepDecorator : stepDecorators = new KubernetesStepDecorator[]{new InitJobManagerDecorator(kubernetesJobManagerParameters), new EnvSecretsDecorator(kubernetesJobManagerParameters), new MountSecretsDecorator(kubernetesJobManagerParameters), new CmdJobManagerDecorator(kubernetesJobManagerParameters), new InternalServiceDecorator(kubernetesJobManagerParameters), new ExternalServiceDecorator(kubernetesJobManagerParameters), new HadoopConfMountDecorator(kubernetesJobManagerParameters), new KerberosMountDecorator(kubernetesJobManagerParameters), new FlinkConfMountDecorator(kubernetesJobManagerParameters), new PodTemplateMountDecorator(kubernetesJobManagerParameters)}) {
            flinkPod = stepDecorator.decorateFlinkPod(flinkPod);
            accompanyingResources.addAll(stepDecorator.buildAccompanyingKubernetesResources());
        }
        Deployment deployment = KubernetesJobManagerFactory.createJobManagerDeployment(flinkPod, kubernetesJobManagerParameters);
        return new KubernetesJobManagerSpecification(deployment, accompanyingResources);
    }

    private static Deployment createJobManagerDeployment(FlinkPod flinkPod, KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        Container resolvedMainContainer = flinkPod.getMainContainer();
        Pod resolvedPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addToContainers(resolvedMainContainer)).endSpec()).build();
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentBuilder)new DeploymentBuilder().withApiVersion("apps/v1")).editOrNewMetadata().withName(KubernetesUtils.getDeploymentName(kubernetesJobManagerParameters.getClusterId()))).withAnnotations(kubernetesJobManagerParameters.getAnnotations())).withLabels(kubernetesJobManagerParameters.getLabels())).withOwnerReferences(kubernetesJobManagerParameters.getOwnerReference().stream().map(e -> (OwnerReference)KubernetesOwnerReference.fromMap(e).getInternalResource()).collect(Collectors.toList()))).endMetadata()).editOrNewSpec().withReplicas(kubernetesJobManagerParameters.getReplicas())).editOrNewTemplate().withMetadata(resolvedPod.getMetadata())).withSpec(resolvedPod.getSpec())).endTemplate()).editOrNewSelector().addToMatchLabels(kubernetesJobManagerParameters.getSelectors())).endSelector()).endSpec()).build();
    }
}

