/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedExtension;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedExtensionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;

public class NamedExtensionBuilder
extends NamedExtensionFluentImpl<NamedExtensionBuilder>
implements VisitableBuilder<NamedExtension, NamedExtensionBuilder> {
    NamedExtensionFluent<?> fluent;
    Boolean validationEnabled;

    public NamedExtensionBuilder() {
        this(false);
    }

    public NamedExtensionBuilder(Boolean validationEnabled) {
        this(new NamedExtension(), validationEnabled);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedExtension(), validationEnabled);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, NamedExtension instance) {
        this(fluent, instance, false);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, NamedExtension instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExtension(instance.getExtension());
        fluent.withName(instance.getName());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NamedExtensionBuilder(NamedExtension instance) {
        this(instance, (Boolean)false);
    }

    public NamedExtensionBuilder(NamedExtension instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExtension(instance.getExtension());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NamedExtension build() {
        NamedExtension buildable = new NamedExtension(this.fluent.getExtension(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedExtensionBuilder that = (NamedExtensionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

