/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v1;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluentImpl;

public class ScaleStatusBuilder
extends ScaleStatusFluentImpl<ScaleStatusBuilder>
implements VisitableBuilder<ScaleStatus, ScaleStatusBuilder> {
    ScaleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleStatusBuilder() {
        this(false);
    }

    public ScaleStatusBuilder(Boolean validationEnabled) {
        this(new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance) {
        this(fluent, instance, false);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ScaleStatusBuilder(ScaleStatus instance) {
        this(instance, (Boolean)false);
    }

    public ScaleStatusBuilder(ScaleStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ScaleStatus build() {
        ScaleStatus buildable = new ScaleStatus(this.fluent.getReplicas(), this.fluent.getSelector());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleStatusBuilder that = (ScaleStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

