/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressStatusFluentImpl;

public class IngressStatusBuilder
extends IngressStatusFluentImpl<IngressStatusBuilder>
implements VisitableBuilder<IngressStatus, IngressStatusBuilder> {
    IngressStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IngressStatusBuilder() {
        this(false);
    }

    public IngressStatusBuilder(Boolean validationEnabled) {
        this(new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, IngressStatus instance) {
        this(fluent, instance, false);
    }

    public IngressStatusBuilder(IngressStatusFluent<?> fluent, IngressStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public IngressStatusBuilder(IngressStatus instance) {
        this(instance, (Boolean)false);
    }

    public IngressStatusBuilder(IngressStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressStatus build() {
        IngressStatus buildable = new IngressStatus(this.fluent.getLoadBalancer());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressStatusBuilder that = (IngressStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

