/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluentImpl;

public class IngressBackendBuilder
extends IngressBackendFluentImpl<IngressBackendBuilder>
implements VisitableBuilder<IngressBackend, IngressBackendBuilder> {
    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBackendBuilder() {
        this(false);
    }

    public IngressBackendBuilder(Boolean validationEnabled) {
        this(new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance) {
        this(fluent, instance, false);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withResource(instance.getResource());
        fluent.withService(instance.getService());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackendBuilder(IngressBackend instance) {
        this(instance, (Boolean)false);
    }

    public IngressBackendBuilder(IngressBackend instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withResource(instance.getResource());
        this.withService(instance.getService());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(this.fluent.getResource(), this.fluent.getService());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendBuilder that = (IngressBackendBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

