/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluentImpl;

public class NetworkPolicyPeerBuilder
extends NetworkPolicyPeerFluentImpl<NetworkPolicyPeerBuilder>
implements VisitableBuilder<NetworkPolicyPeer, NetworkPolicyPeerBuilder> {
    NetworkPolicyPeerFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyPeerBuilder() {
        this(false);
    }

    public NetworkPolicyPeerBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, NetworkPolicyPeer instance) {
        this(fluent, instance, false);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, NetworkPolicyPeer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIpBlock(instance.getIpBlock());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withPodSelector(instance.getPodSelector());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance) {
        this(instance, (Boolean)false);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIpBlock(instance.getIpBlock());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodSelector(instance.getPodSelector());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicyPeer build() {
        NetworkPolicyPeer buildable = new NetworkPolicyPeer(this.fluent.getIpBlock(), this.fluent.getNamespaceSelector(), this.fluent.getPodSelector());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPeerBuilder that = (NetworkPolicyPeerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

