/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.io.InputStream;
import java.net.URL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ComponentStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ComponentStatusList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMap;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Endpoints;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EndpointsList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LimitRange;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LimitRangeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Namespace;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Node;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceQuota;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceQuotaList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.RootPaths;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Secret;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccount;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccountList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Adapters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ClientContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.DefaultKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ExtensionAdapter;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.VersionInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AuthorizationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.BatchAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.DiscoveryAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PolicyAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RbacAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ServiceResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.StorageAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunOperations;

public class AutoAdaptableKubernetesClient
extends DefaultKubernetesClient {
    private KubernetesClient delegate;

    public AutoAdaptableKubernetesClient() {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient());
    }

    public AutoAdaptableKubernetesClient(ClientContext clientContext) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(clientContext));
    }

    public AutoAdaptableKubernetesClient(Config config) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(config));
    }

    public AutoAdaptableKubernetesClient(String masterUrl) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(masterUrl));
    }

    public static KubernetesClient adapt(KubernetesClient initial) {
        KubernetesClient result = initial;
        for (ExtensionAdapter<KubernetesClient> adapter : Adapters.list(KubernetesClient.class)) {
            if (!adapter.isAdaptable(result).booleanValue()) continue;
            result = adapter.adapt(result);
        }
        return result;
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new AutoAdaptableKubernetesClient(this.newState(updated));
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.delegate.admissionRegistration();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.delegate.discovery();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public RunOperations run() {
        return this.delegate.run();
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        return this.delegate.isAdaptable(type);
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }
}

