/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Status;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.OperationInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;

public class KubernetesClientException
extends RuntimeException {
    private final int code;
    private final Status status;
    private final RequestMetadata requestMetadata;

    public KubernetesClientException(String message) {
        this(message, null);
    }

    public KubernetesClientException(String message, Throwable t) {
        this(message, t, -1, null, (RequestMetadata)null);
    }

    public KubernetesClientException(Status status) {
        this(status.getMessage(), status.getCode(), status);
    }

    public KubernetesClientException(String message, int code, Status status) {
        this(message, null, code, status, (RequestMetadata)null);
    }

    public KubernetesClientException(String message, Throwable t, int code, Status status, HttpRequest httpRequest) {
        this(message, t, code, status, RequestMetadata.from(httpRequest));
    }

    private KubernetesClientException(String message, Throwable t, int code, Status status, RequestMetadata requestMetadata) {
        super(message, t);
        this.code = code;
        this.status = status;
        this.requestMetadata = requestMetadata;
    }

    @Deprecated
    public KubernetesClientException(String message, int code, Status status, String group, String version, String resourcePlural, String namespace) {
        this(message, null, code, status, RequestMetadata.builder().group(group).version(version).plural(resourcePlural).namespace(namespace).build());
    }

    @Deprecated
    public KubernetesClientException(String message, Throwable t, String group, String version, String resourcePlural, String namespace) {
        this(message, t, -1, null, RequestMetadata.builder().group(group).version(version).plural(resourcePlural).namespace(namespace).build());
    }

    public Status getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public String getGroup() {
        return this.requestMetadata.group;
    }

    public String getVersion() {
        return this.requestMetadata.version;
    }

    public String getResourcePlural() {
        return this.requestMetadata.plural;
    }

    public String getNamespace() {
        return this.requestMetadata.namespace;
    }

    public String getName() {
        return this.requestMetadata.name;
    }

    public String getFullResourceName() {
        if (this.requestMetadata.plural != null && this.requestMetadata.group != null) {
            return HasMetadata.getFullResourceName(this.requestMetadata.plural, this.requestMetadata.group);
        }
        return null;
    }

    public static RuntimeException launderThrowable(Throwable cause) {
        return KubernetesClientException.launderThrowable("An error has occurred.", cause);
    }

    public static RuntimeException launderThrowable(String message, Throwable cause) {
        RuntimeException processed = KubernetesClientException.processCause(cause);
        if (processed != null) {
            return processed;
        }
        throw new KubernetesClientException(message, cause);
    }

    private static RuntimeException processCause(Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public static RuntimeException launderThrowable(OperationInfo spec, Throwable cause) {
        Status status;
        RuntimeException processed = KubernetesClientException.processCause(cause);
        if (processed != null) {
            return processed;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(KubernetesClientException.describeOperation(spec)).append(" failed.");
        if (cause instanceof KubernetesClientException && (status = ((KubernetesClientException)cause).getStatus()) != null && Utils.isNotNullOrEmpty(status.getMessage())) {
            sb.append("Reason: ").append(status.getMessage());
        }
        throw new KubernetesClientException(sb.toString(), cause, -1, null, RequestMetadata.builder().group(spec.getGroup()).version(spec.getVersion()).plural(spec.getPlural()).namespace(spec.getNamespace()).name(spec.getName()).build());
    }

    @Deprecated
    public static RuntimeException launderThrowable(OperationInfo spec, Status status, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append(KubernetesClientException.describeOperation(spec)).append(" failed.");
        if (status != null && Utils.isNotNullOrEmpty(status.getMessage())) {
            sb.append("Reason: ").append(status.getMessage());
        }
        return KubernetesClientException.launderThrowable(sb.toString(), cause);
    }

    private static String describeOperation(OperationInfo operation) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation");
        if (Utils.isNotNullOrEmpty(operation.getOperationType())) {
            sb.append(": [").append(operation.getOperationType()).append("]");
        }
        sb.append(" ");
        sb.append(" for kind: [").append(operation.getKind()).append("] ");
        sb.append(" with name: [").append(operation.getName()).append("] ");
        sb.append(" in namespace: [").append(operation.getNamespace()).append("] ");
        return sb.toString();
    }

    private static class RequestMetadata
    implements Serializable {
        private static final RequestMetadata EMPTY = new RequestMetadata(null, null, null, null, null);
        final String group;
        final String version;
        final String plural;
        final String namespace;
        final String name;

        static RequestMetadata from(HttpRequest request) {
            return RequestMetadata.from(request.uri());
        }

        static RequestMetadata from(URI request) {
            List segments = Arrays.stream(request.getRawPath().split("/")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            switch (segments.size()) {
                case 3: {
                    return RequestMetadata.builder().group("").version((String)segments.get(1)).plural((String)segments.get(2)).build();
                }
                case 4: {
                    return RequestMetadata.builder().group((String)segments.get(1)).version((String)segments.get(2)).plural((String)segments.get(3)).build();
                }
                case 6: {
                    String root = (String)segments.get(0);
                    if ("api".equals(root)) {
                        return RequestMetadata.builder().group("").version((String)segments.get(1)).plural((String)segments.get(4)).namespace((String)segments.get(3)).name((String)segments.get(5)).build();
                    }
                    return RequestMetadata.builder().group((String)segments.get(1)).version((String)segments.get(2)).plural((String)segments.get(5)).namespace((String)segments.get(4)).build();
                }
                case 7: {
                    return RequestMetadata.builder().group((String)segments.get(1)).version((String)segments.get(2)).plural((String)segments.get(5)).namespace((String)segments.get(4)).name((String)segments.get(6)).build();
                }
            }
            return EMPTY;
        }

        public static RequestMetadataBuilder builder() {
            return new RequestMetadataBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestMetadata)) {
                return false;
            }
            RequestMetadata other = (RequestMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$group = this.group;
            String other$group = other.group;
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$version = this.version;
            String other$version = other.version;
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$plural = this.plural;
            String other$plural = other.plural;
            if (this$plural == null ? other$plural != null : !this$plural.equals(other$plural)) {
                return false;
            }
            String this$namespace = this.namespace;
            String other$namespace = other.namespace;
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.group;
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $version = this.version;
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $plural = this.plural;
            result = result * 59 + ($plural == null ? 43 : $plural.hashCode());
            String $namespace = this.namespace;
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        private RequestMetadata(String group, String version, String plural, String namespace, String name) {
            this.group = group;
            this.version = version;
            this.plural = plural;
            this.namespace = namespace;
            this.name = name;
        }

        public static class RequestMetadataBuilder {
            private String group;
            private String version;
            private String plural;
            private String namespace;
            private String name;

            RequestMetadataBuilder() {
            }

            public RequestMetadataBuilder group(String group) {
                this.group = group;
                return this;
            }

            public RequestMetadataBuilder version(String version) {
                this.version = version;
                return this;
            }

            public RequestMetadataBuilder plural(String plural) {
                this.plural = plural;
                return this;
            }

            public RequestMetadataBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public RequestMetadataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public RequestMetadata build() {
                return new RequestMetadata(this.group, this.version, this.plural, this.namespace, this.name);
            }

            public String toString() {
                return "KubernetesClientException.RequestMetadata.RequestMetadataBuilder(group=" + this.group + ", version=" + this.version + ", plural=" + this.plural + ", namespace=" + this.namespace + ", name=" + this.name + ")";
            }
        }
    }
}

