/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServicePort;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ServiceToURLProvider;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.URLFromServiceUtil;

public class URLFromIngressImpl
implements ServiceToURLProvider {
    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceName = service.getMetadata().getName();
        if (port == null) {
            throw new RuntimeException("Couldn't find port: " + portName + " for service " + service.getMetadata().getName());
        }
        IngressList ingresses = (IngressList)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).list();
        if (ingresses != null && !ingresses.getItems().isEmpty()) {
            return URLFromServiceUtil.getURLFromIngressList(ingresses.getItems(), namespace, serviceName, port);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FIRST.getValue();
    }
}

