/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ClientContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Operation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.WatchListDeletable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl;

class DeploymentRollingUpdater
extends RollingUpdater<Deployment, DeploymentList> {
    DeploymentRollingUpdater(ClientContext clientContext, String namespace) {
        super(clientContext, namespace);
    }

    DeploymentRollingUpdater(ClientContext clientContext, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(clientContext, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected Deployment createClone(Deployment obj, String newName, String newDeploymentHash) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected WatchListDeletable<Pod, PodList> selectedPodLister(Deployment obj) {
        return this.selectedPodLister(obj.getSpec().getSelector());
    }

    @Override
    protected Deployment updateDeploymentKey(String name, String hash) {
        Deployment old = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        Deployment updated = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)new DeploymentBuilder(old).editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected Deployment removeDeploymentKey(String name) {
        Deployment old = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        Deployment updated = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)new DeploymentBuilder(old).editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected int getReplicas(Deployment obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected Deployment setReplicas(Deployment obj, int replicas) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)new DeploymentBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<Deployment, DeploymentList, RollableScalableResource<Deployment>> resources() {
        return new DeploymentOperationsImpl(this.clientContext);
    }
}

