/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal;

import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMeta;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal.serializationmixins.ObjectMetaMixIn;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal.serializationmixins.ReplicationControllerMixIn;

public class SerializationUtils {
    private static ObjectMapper mapper;
    private static ObjectMapper statelessMapper;

    private SerializationUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ObjectMapper getStatelessMapper() {
        if (statelessMapper == null) {
            statelessMapper = new ObjectMapper(new YAMLFactory());
            statelessMapper.addMixInAnnotations(ObjectMeta.class, ObjectMetaMixIn.class);
            statelessMapper.addMixInAnnotations(ReplicationController.class, ReplicationControllerMixIn.class);
        }
        return statelessMapper;
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper(new YAMLFactory());
        }
        return mapper;
    }

    public static String dumpAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getMapper().writeValueAsString(obj);
    }

    public static String dumpWithoutRuntimeStateAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getStatelessMapper().writeValueAsString(obj);
    }
}

