/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Serialization;

public class IOHelpers {
    private IOHelpers() {
        throw new IllegalStateException("Utility class");
    }

    public static String readFully(InputStream in, Charset charset) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in, charset));
        return IOHelpers.readFully(r);
    }

    public static String readFully(InputStream in) throws IOException {
        return IOHelpers.readFully(in, Charset.defaultCharset());
    }

    public static String readFully(Reader r) throws IOException {
        try (StringWriter w = new StringWriter();){
            IOHelpers.copy(r, w);
            String string = w.toString();
            return string;
        }
    }

    private static void copy(Reader reader, Writer writer) throws IOException {
        int len;
        char[] buffer = new char[8192];
        while ((len = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, len);
        }
        writer.flush();
    }

    public static boolean isJSONValid(String json) {
        try {
            ObjectMapper objectMapper = Serialization.jsonMapper();
            objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            return false;
        }
        return true;
    }

    public static String convertYamlToJson(String yaml) throws IOException {
        ObjectMapper yamlReader = Serialization.yamlMapper();
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = Serialization.jsonMapper();
        return jsonWriter.writeValueAsString(obj);
    }

    public static String convertToJson(String jsonOrYaml) throws IOException {
        if (IOHelpers.isJSONValid(jsonOrYaml)) {
            return jsonOrYaml;
        }
        return IOHelpers.convertYamlToJson(jsonOrYaml);
    }
}

