/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Watcher;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.WatcherException;

public class WatcherToggle<T>
implements Watcher<T> {
    private final Watcher<T> delegate;
    private boolean enabled;

    public WatcherToggle(Watcher<T> delegate, boolean enabled) {
        this.delegate = Objects.requireNonNull(delegate, "delegate watcher cannot be null");
        this.enabled = enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        if (this.enabled) {
            this.delegate.eventReceived(action, resource);
        }
    }

    @Override
    public void onClose(WatcherException cause) {
        if (this.enabled) {
            this.delegate.onClose(cause);
        }
    }

    @Override
    public void onClose() {
        if (this.enabled) {
            this.delegate.onClose();
        }
    }

    @Override
    public boolean reconnecting() {
        return this.delegate.reconnecting();
    }
}

