/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.maprfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRFileSystem
extends HadoopFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MapRFileSystem.class);
    private static final String MAPR_HOME_ENV = "MAPR_HOME";
    private static final String DEFAULT_MAPR_HOME = "/opt/mapr/";
    private static final String MAPR_CLUSTER_CONF_FILE = "/conf/mapr-clusters.conf";

    public MapRFileSystem(URI fsUri) throws IOException {
        super(MapRFileSystem.instantiateMapRFileSystem(fsUri));
    }

    private static FileSystem instantiateMapRFileSystem(URI fsUri) throws IOException {
        com.mapr.fs.MapRFileSystem fs;
        Preconditions.checkNotNull((Object)fsUri, (String)"fsUri");
        Configuration conf = new Configuration();
        String authority = fsUri.getAuthority();
        if (authority == null || authority.isEmpty()) {
            fs = new com.mapr.fs.MapRFileSystem();
        } else {
            String[] cldbLocations = MapRFileSystem.getCLDBLocations(authority);
            fs = new com.mapr.fs.MapRFileSystem(authority, cldbLocations);
        }
        fs.initialize(fsUri, conf);
        return fs;
    }

    private static String[] getCLDBLocations(String authority) throws IOException {
        String maprHome = System.getenv(MAPR_HOME_ENV);
        if (maprHome == null) {
            maprHome = DEFAULT_MAPR_HOME;
        }
        File maprClusterConf = new File(maprHome, MAPR_CLUSTER_CONF_FILE);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Trying to retrieve MapR cluster configuration from %s", maprClusterConf));
        }
        if (!maprClusterConf.exists()) {
            throw new IOException("Could not find CLDB configuration '" + maprClusterConf.getAbsolutePath() + "', assuming MapR home is '" + maprHome + "'.");
        }
        try (BufferedReader br = new BufferedReader(new FileReader(maprClusterConf));){
            String line;
            while ((line = br.readLine()) != null) {
                String clusterName;
                line = line.trim();
                String[] fields = (line = line.replace('\t', ' ')).split(" ");
                if (fields.length < 1 || !(clusterName = fields[0]).equals(authority)) continue;
                ArrayList<String> cldbLocations = new ArrayList<String>();
                for (int i = 1; i < fields.length; ++i) {
                    if (fields[i].isEmpty() || fields[i].contains("=")) continue;
                    cldbLocations.add(fields[i]);
                }
                if (cldbLocations.isEmpty()) {
                    throw new IOException(String.format("%s contains entry for cluster %s but no CLDB locations.", maprClusterConf, authority));
                }
                String[] stringArray = cldbLocations.toArray(new String[cldbLocations.size()]);
                return stringArray;
            }
        }
        throw new IOException(String.format("Unable to find CLDB locations for cluster %s", authority));
    }
}

