/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.dag.TempMode;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitor;
import org.junit.Assert;
import org.junit.Test;

public class CachedMatchStrategyCompilerTest
extends CompilerTestBase {
    @Test
    public void testRightSide() {
        try {
            Plan plan = this.getTestPlanRightStatic("LOCAL_STRATEGY_HASH_BUILD_SECOND");
            OptimizedPlan oPlan = this.compileNoStats(plan);
            CompilerTestBase.OptimizerPlanNodeResolver resolver = CachedMatchStrategyCompilerTest.getOptimizerPlanNodeResolver(oPlan);
            DualInputPlanNode innerJoin = (DualInputPlanNode)resolver.getNode("DummyJoiner");
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND_CACHED, (Object)innerJoin.getDriverStrategy());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput1().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput2().getTempMode());
            new JobGraphGenerator().compileJobGraph(oPlan);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test errored: " + e.getMessage()));
        }
    }

    @Test
    public void testRightSideCountercheck() {
        try {
            Plan plan = this.getTestPlanRightStatic("LOCAL_STRATEGY_HASH_BUILD_FIRST");
            OptimizedPlan oPlan = this.compileNoStats(plan);
            CompilerTestBase.OptimizerPlanNodeResolver resolver = CachedMatchStrategyCompilerTest.getOptimizerPlanNodeResolver(oPlan);
            DualInputPlanNode innerJoin = (DualInputPlanNode)resolver.getNode("DummyJoiner");
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_FIRST, (Object)innerJoin.getDriverStrategy());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput1().getTempMode());
            Assert.assertEquals((Object)TempMode.CACHED, (Object)innerJoin.getInput2().getTempMode());
            new JobGraphGenerator().compileJobGraph(oPlan);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test errored: " + e.getMessage()));
        }
    }

    @Test
    public void testLeftSide() {
        try {
            Plan plan = this.getTestPlanLeftStatic("LOCAL_STRATEGY_HASH_BUILD_FIRST");
            OptimizedPlan oPlan = this.compileNoStats(plan);
            CompilerTestBase.OptimizerPlanNodeResolver resolver = CachedMatchStrategyCompilerTest.getOptimizerPlanNodeResolver(oPlan);
            DualInputPlanNode innerJoin = (DualInputPlanNode)resolver.getNode("DummyJoiner");
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_FIRST_CACHED, (Object)innerJoin.getDriverStrategy());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput1().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput2().getTempMode());
            new JobGraphGenerator().compileJobGraph(oPlan);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test errored: " + e.getMessage()));
        }
    }

    @Test
    public void testLeftSideCountercheck() {
        try {
            Plan plan = this.getTestPlanLeftStatic("LOCAL_STRATEGY_HASH_BUILD_SECOND");
            OptimizedPlan oPlan = this.compileNoStats(plan);
            CompilerTestBase.OptimizerPlanNodeResolver resolver = CachedMatchStrategyCompilerTest.getOptimizerPlanNodeResolver(oPlan);
            DualInputPlanNode innerJoin = (DualInputPlanNode)resolver.getNode("DummyJoiner");
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND, (Object)innerJoin.getDriverStrategy());
            Assert.assertEquals((Object)TempMode.CACHED, (Object)innerJoin.getInput1().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput2().getTempMode());
            new JobGraphGenerator().compileJobGraph(oPlan);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test errored: " + e.getMessage()));
        }
    }

    @Test
    public void testCorrectChoosing() {
        try {
            Plan plan = this.getTestPlanRightStatic("");
            CompilerTestBase.SourceCollectorVisitor sourceCollector = new CompilerTestBase.SourceCollectorVisitor();
            plan.accept((Visitor)sourceCollector);
            for (GenericDataSourceBase<?, ?> s : sourceCollector.getSources()) {
                if (s.getName().equals("bigFile")) {
                    this.setSourceStatistics(s, 10000000L, 1000.0f);
                    continue;
                }
                if (!s.getName().equals("smallFile")) continue;
                this.setSourceStatistics(s, 100L, 100.0f);
            }
            OptimizedPlan oPlan = this.compileNoStats(plan);
            CompilerTestBase.OptimizerPlanNodeResolver resolver = CachedMatchStrategyCompilerTest.getOptimizerPlanNodeResolver(oPlan);
            DualInputPlanNode innerJoin = (DualInputPlanNode)resolver.getNode("DummyJoiner");
            Assert.assertEquals((Object)DriverStrategy.HYBRIDHASH_BUILD_SECOND_CACHED, (Object)innerJoin.getDriverStrategy());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput1().getTempMode());
            Assert.assertEquals((Object)TempMode.NONE, (Object)innerJoin.getInput2().getTempMode());
            new JobGraphGenerator().compileJobGraph(oPlan);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test errored: " + e.getMessage()));
        }
    }

    private Plan getTestPlanRightStatic(String strategy) {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(8);
        Operator bigInput = env.readCsvFile("file://bigFile").types(Long.class, Long.class, Long.class).name("bigFile");
        Operator smallInput = env.readCsvFile("file://smallFile").types(Long.class, Long.class, Long.class).name("smallFile");
        IterativeDataSet iteration = bigInput.iterate(10);
        Configuration joinStrategy = new Configuration();
        joinStrategy.setString("INPUT_SHIP_STRATEGY", "SHIP_REPARTITION_HASH");
        if (!strategy.equals("")) {
            joinStrategy.setString("LOCAL_STRATEGY", strategy);
        }
        TwoInputUdfOperator inner = ((JoinOperator)iteration.join((DataSet)smallInput).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new DummyJoiner()).name("DummyJoiner")).withParameters(joinStrategy);
        DataSet output = iteration.closeWith((DataSet)inner);
        output.output((OutputFormat)new DiscardingOutputFormat());
        return env.createProgramPlan();
    }

    private Plan getTestPlanLeftStatic(String strategy) {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(8);
        Operator bigInput = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)1L, (Object)2L, (Object)3L), new Tuple3((Object)1L, (Object)2L, (Object)3L), new Tuple3((Object)1L, (Object)2L, (Object)3L)}).name("Big");
        Operator smallInput = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)1L, (Object)2L, (Object)3L)}).name("Small");
        IterativeDataSet iteration = bigInput.iterate(10);
        Configuration joinStrategy = new Configuration();
        joinStrategy.setString("LOCAL_STRATEGY", strategy);
        TwoInputUdfOperator inner = ((JoinOperator)smallInput.join((DataSet)iteration).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new DummyJoiner()).name("DummyJoiner")).withParameters(joinStrategy);
        DataSet output = iteration.closeWith((DataSet)inner);
        output.output((OutputFormat)new DiscardingOutputFormat());
        return env.createProgramPlan();
    }

    private static class DummyJoiner
    extends RichJoinFunction<Tuple3<Long, Long, Long>, Tuple3<Long, Long, Long>, Tuple3<Long, Long, Long>> {
        private DummyJoiner() {
        }

        public Tuple3<Long, Long, Long> join(Tuple3<Long, Long, Long> first, Tuple3<Long, Long, Long> second) throws Exception {
            return first;
        }
    }
}

