/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.optimizer.plan.BinaryUnionPlanNode;
import org.apache.flink.optimizer.plan.BulkIterationPlanNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.NAryUnionPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class UnionBetweenDynamicAndStaticPathTest
extends CompilerTestBase {
    @Test
    public void testUnionStaticFirst() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.generateSequence(1L, 10L);
            DataSource input2 = env.generateSequence(1L, 10L);
            IterativeDataSet iteration = input1.iterate(10);
            DataSet result = iteration.closeWith((DataSet)input2.union((DataSet)input2).union((DataSet)iteration.union((DataSet)iteration)));
            result.output((OutputFormat)new DiscardingOutputFormat());
            result.output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            Assert.assertEquals((long)2L, (long)op.getDataSinks().size());
            BulkIterationPlanNode iterPlan = (BulkIterationPlanNode)((SinkPlanNode)op.getDataSinks().iterator().next()).getInput().getSource();
            SingleInputPlanNode noopNode = (SingleInputPlanNode)iterPlan.getRootOfStepFunction();
            BinaryUnionPlanNode mixedUnion = (BinaryUnionPlanNode)noopNode.getInput().getSource();
            NAryUnionPlanNode staticUnion = (NAryUnionPlanNode)mixedUnion.getInput1().getSource();
            NAryUnionPlanNode dynamicUnion = (NAryUnionPlanNode)mixedUnion.getInput2().getSource();
            Assert.assertTrue((boolean)mixedUnion.unionsStaticAndDynamicPath());
            Assert.assertFalse((boolean)mixedUnion.getInput1().isOnDynamicPath());
            Assert.assertTrue((boolean)mixedUnion.getInput2().isOnDynamicPath());
            Assert.assertTrue((boolean)mixedUnion.getInput1().getTempMode().isCached());
            for (Channel c : staticUnion.getInputs()) {
                Assert.assertFalse((boolean)c.isOnDynamicPath());
            }
            for (Channel c : dynamicUnion.getInputs()) {
                Assert.assertTrue((boolean)c.isOnDynamicPath());
            }
            Assert.assertEquals((double)0.5, (double)iterPlan.getRelativeMemoryPerSubTask(), (double)0.0);
            Assert.assertEquals((double)0.5, (double)mixedUnion.getInput1().getRelativeTempMemory(), (double)0.0);
            Assert.assertEquals((double)0.0, (double)mixedUnion.getInput2().getRelativeTempMemory(), (double)0.0);
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnionStaticSecond() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.generateSequence(1L, 10L);
            DataSource input2 = env.generateSequence(1L, 10L);
            IterativeDataSet iteration = input1.iterate(10);
            DataSet iterResult = iteration.closeWith((DataSet)iteration.union((DataSet)iteration).union((DataSet)input2.union((DataSet)input2)));
            iterResult.output((OutputFormat)new DiscardingOutputFormat());
            iterResult.output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            Assert.assertEquals((long)2L, (long)op.getDataSinks().size());
            BulkIterationPlanNode iterPlan = (BulkIterationPlanNode)((SinkPlanNode)op.getDataSinks().iterator().next()).getInput().getSource();
            SingleInputPlanNode noopNode = (SingleInputPlanNode)iterPlan.getRootOfStepFunction();
            BinaryUnionPlanNode mixedUnion = (BinaryUnionPlanNode)noopNode.getInput().getSource();
            NAryUnionPlanNode staticUnion = (NAryUnionPlanNode)mixedUnion.getInput1().getSource();
            NAryUnionPlanNode dynamicUnion = (NAryUnionPlanNode)mixedUnion.getInput2().getSource();
            Assert.assertTrue((boolean)mixedUnion.unionsStaticAndDynamicPath());
            Assert.assertFalse((boolean)mixedUnion.getInput1().isOnDynamicPath());
            Assert.assertTrue((boolean)mixedUnion.getInput2().isOnDynamicPath());
            Assert.assertTrue((boolean)mixedUnion.getInput1().getTempMode().isCached());
            Assert.assertEquals((double)0.5, (double)iterPlan.getRelativeMemoryPerSubTask(), (double)0.0);
            Assert.assertEquals((double)0.5, (double)mixedUnion.getInput1().getRelativeTempMemory(), (double)0.0);
            Assert.assertEquals((double)0.0, (double)mixedUnion.getInput2().getRelativeTempMemory(), (double)0.0);
            for (Channel c : staticUnion.getInputs()) {
                Assert.assertFalse((boolean)c.isOnDynamicPath());
            }
            for (Channel c : dynamicUnion.getInputs()) {
                Assert.assertTrue((boolean)c.isOnDynamicPath());
            }
            new JobGraphGenerator().compileJobGraph(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

