/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.custompartition;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.IdentityGroupReducerCombinable;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class CustomPartitioningGlobalOptimizationTest
extends CompilerTestBase {
    @Test
    public void testJoinReduceCombination() {
        try {
            TestPartitionerLong partitioner = new TestPartitionerLong();
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            JoinOperator joined = input1.join((DataSet)input2).where(new int[]{1}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1}).projectSecond(new int[]{2}).withPartitioner((Partitioner)partitioner);
            joined.groupBy(new int[]{1}).withPartitioner((Partitioner)partitioner).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            Assert.assertTrue((String)"Reduce is not chained, property reuse does not happen", (boolean)(reducer.getInput().getSource() instanceof DualInputPlanNode));
            DualInputPlanNode join = (DualInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)join.getInput1().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)join.getInput2().getShipStrategy());
            Assert.assertEquals((Object)partitioner, (Object)join.getInput1().getPartitioner());
            Assert.assertEquals((Object)partitioner, (Object)join.getInput2().getPartitioner());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)reducer.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class TestPartitionerLong
    implements Partitioner<Long> {
        private TestPartitionerLong() {
        }

        public int partition(Long key, int numPartitions) {
            return 0;
        }
    }
}

