/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.custompartition;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.IdentityGroupReducerCombinable;
import org.apache.flink.optimizer.testfunctions.SelectOneReducer;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class GroupingTupleTranslationTest
extends CompilerTestBase {
    @Test
    public void testCustomPartitioningTupleAgg() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0, (Object)0)}).rebalance().setParallelism(4);
            data.groupBy(new int[]{0}).withPartitioner((Partitioner)new TestPartitionerInt()).sum(1).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleReduce() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0, (Object)0)}).rebalance().setParallelism(4);
            data.groupBy(new int[]{0}).withPartitioner((Partitioner)new TestPartitionerInt()).reduce(new SelectOneReducer()).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleGroupReduce() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0, (Object)0)}).rebalance().setParallelism(4);
            data.groupBy(new int[]{0}).withPartitioner((Partitioner)new TestPartitionerInt()).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleGroupReduceSorted() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0, (Object)0, (Object)0)}).rebalance().setParallelism(4);
            data.groupBy(new int[]{0}).withPartitioner((Partitioner)new TestPartitionerInt()).sortGroup(1, Order.ASCENDING).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleGroupReduceSorted2() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple4[]{new Tuple4((Object)0, (Object)0, (Object)0, (Object)0)}).rebalance().setParallelism(4);
            data.groupBy(new int[]{0}).withPartitioner((Partitioner)new TestPartitionerInt()).sortGroup(1, Order.ASCENDING).sortGroup(2, Order.DESCENDING).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats(p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleInvalidType() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0, (Object)0)}).rebalance().setParallelism(4);
            try {
                data.groupBy(new int[]{0}).withPartitioner((Partitioner)new TestPartitionerLong());
                Assert.fail((String)"Should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleInvalidTypeSorted() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0, (Object)0, (Object)0)}).rebalance().setParallelism(4);
            try {
                data.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).withPartitioner((Partitioner)new TestPartitionerLong());
                Assert.fail((String)"Should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCustomPartitioningTupleRejectCompositeKey() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0, (Object)0, (Object)0)}).rebalance().setParallelism(4);
            try {
                data.groupBy(new int[]{0, 1}).withPartitioner((Partitioner)new TestPartitionerInt());
                Assert.fail((String)"Should throw an exception");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class TestPartitionerLong
    implements Partitioner<Long> {
        private TestPartitionerLong() {
        }

        public int partition(Long key, int numPartitions) {
            return 0;
        }
    }

    private static class TestPartitionerInt
    implements Partitioner<Integer> {
        private TestPartitionerInt() {
        }

        public int partition(Integer key, int numPartitions) {
            return 0;
        }
    }
}

