/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataexchange;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.DummyCoGroupFunction;
import org.apache.flink.optimizer.testfunctions.DummyFlatJoinFunction;
import org.apache.flink.optimizer.testfunctions.IdentityFlatMapper;
import org.apache.flink.optimizer.testfunctions.SelectOneReducer;
import org.apache.flink.optimizer.testfunctions.Top1GroupReducer;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.junit.Assert;
import org.junit.Test;

public class DataExchangeModeClosedBranchingTest
extends CompilerTestBase {
    @Test
    public void testPipelinedForced() {
        this.verifyBranchingJoiningPlan(ExecutionMode.PIPELINED_FORCED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED);
    }

    @Test
    public void testPipelined() {
        this.verifyBranchingJoiningPlan(ExecutionMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED);
    }

    @Test
    public void testBatch() {
        this.verifyBranchingJoiningPlan(ExecutionMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED);
    }

    @Test
    public void testBatchForced() {
        this.verifyBranchingJoiningPlan(ExecutionMode.BATCH_FORCED, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.PIPELINED, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH, DataExchangeMode.BATCH);
    }

    private void verifyBranchingJoiningPlan(ExecutionMode execMode, DataExchangeMode toMap, DataExchangeMode toReduceCombiner, DataExchangeMode toReduce, DataExchangeMode toFilter, DataExchangeMode toReduceSink, DataExchangeMode toJoin1, DataExchangeMode toJoin2, DataExchangeMode toOtherReduceCombiner, DataExchangeMode toOtherReduce, DataExchangeMode toFlatMap, DataExchangeMode toFlatMapSink, DataExchangeMode toCoGroup1, DataExchangeMode toCoGroup2, DataExchangeMode toCoGroupSink) {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.getConfig().setExecutionMode(execMode);
            env.setParallelism(2);
            MapOperator data = env.fromElements((Object[])new Long[]{33L, 44L}).map((MapFunction)new MapFunction<Long, Tuple2<Long, Long>>(){

                public Tuple2<Long, Long> map(Long value) {
                    return new Tuple2((Object)value, (Object)value);
                }
            });
            ReduceOperator reduced = data.groupBy(new int[]{0}).reduce(new SelectOneReducer());
            reduced.output((OutputFormat)new DiscardingOutputFormat()).name("reduceSink");
            FilterOperator filtered = data.filter((FilterFunction)new FilterFunction<Tuple2<Long, Long>>(){

                public boolean filter(Tuple2<Long, Long> value) throws Exception {
                    return false;
                }
            });
            JoinOperator.EquiJoin joined = reduced.join((DataSet)filtered).where(new int[]{1}).equalTo(new int[]{1}).with(new DummyFlatJoinFunction());
            joined.flatMap(new IdentityFlatMapper()).output((OutputFormat)new DiscardingOutputFormat()).name("flatMapSink");
            joined.coGroup((DataSet)filtered.groupBy(new int[]{1}).reduceGroup(new Top1GroupReducer())).where(new int[]{0}).equalTo(new int[]{0}).with(new DummyCoGroupFunction()).output((OutputFormat)new DiscardingOutputFormat()).name("cgSink");
            OptimizedPlan optPlan = this.compileNoStats(env.createProgramPlan());
            SinkPlanNode reduceSink = this.findSink(optPlan.getDataSinks(), "reduceSink");
            SinkPlanNode flatMapSink = this.findSink(optPlan.getDataSinks(), "flatMapSink");
            SinkPlanNode cgSink = this.findSink(optPlan.getDataSinks(), "cgSink");
            DualInputPlanNode coGroupNode = (DualInputPlanNode)cgSink.getPredecessor();
            DualInputPlanNode joinNode = (DualInputPlanNode)coGroupNode.getInput1().getSource();
            SingleInputPlanNode otherReduceNode = (SingleInputPlanNode)coGroupNode.getInput2().getSource();
            SingleInputPlanNode otherReduceCombinerNode = (SingleInputPlanNode)otherReduceNode.getPredecessor();
            SingleInputPlanNode reduceNode = (SingleInputPlanNode)joinNode.getInput1().getSource();
            SingleInputPlanNode reduceCombinerNode = (SingleInputPlanNode)reduceNode.getPredecessor();
            Assert.assertEquals((Object)reduceNode, (Object)reduceSink.getPredecessor());
            SingleInputPlanNode filterNode = (SingleInputPlanNode)joinNode.getInput2().getSource();
            Assert.assertEquals((Object)filterNode, (Object)otherReduceCombinerNode.getPredecessor());
            SingleInputPlanNode mapNode = (SingleInputPlanNode)filterNode.getPredecessor();
            Assert.assertEquals((Object)mapNode, (Object)reduceCombinerNode.getPredecessor());
            SingleInputPlanNode flatMapNode = (SingleInputPlanNode)flatMapSink.getPredecessor();
            Assert.assertEquals((Object)joinNode, (Object)flatMapNode.getPredecessor());
            Assert.assertEquals((Object)toReduceSink, (Object)reduceSink.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toFlatMapSink, (Object)flatMapSink.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toCoGroupSink, (Object)cgSink.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toCoGroup1, (Object)coGroupNode.getInput1().getDataExchangeMode());
            Assert.assertEquals((Object)toCoGroup2, (Object)coGroupNode.getInput2().getDataExchangeMode());
            Assert.assertEquals((Object)toJoin1, (Object)joinNode.getInput1().getDataExchangeMode());
            Assert.assertEquals((Object)toJoin2, (Object)joinNode.getInput2().getDataExchangeMode());
            Assert.assertEquals((Object)toOtherReduce, (Object)otherReduceNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toOtherReduceCombiner, (Object)otherReduceCombinerNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toFlatMap, (Object)flatMapNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toFilter, (Object)filterNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toReduce, (Object)reduceNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toReduceCombiner, (Object)reduceCombinerNode.getInput().getDataExchangeMode());
            Assert.assertEquals((Object)toMap, (Object)mapNode.getInput().getDataExchangeMode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private SinkPlanNode findSink(Collection<SinkPlanNode> collection, String name) {
        for (SinkPlanNode node : collection) {
            String nodeName = node.getOptimizerNode().getOperator().getName();
            if (nodeName == null || !nodeName.equals(name)) continue;
            return node;
        }
        throw new IllegalArgumentException("No node with that name was found.");
    }
}

