/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.MockPartitioner;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.junit.Assert;
import org.junit.Test;

public class GlobalPropertiesMatchingTest {
    @Test
    public void testMatchingAnyPartitioning() {
        try {
            RequestedGlobalProperties req = new RequestedGlobalProperties();
            req.setAnyPartitioning(new FieldSet(new int[]{6, 2}));
            GlobalProperties gp1 = new GlobalProperties();
            gp1.setAnyPartitioning(new FieldList(new int[]{2, 6}));
            Assert.assertTrue((boolean)req.isMetBy(gp1));
            GlobalProperties gp2 = new GlobalProperties();
            gp2.setAnyPartitioning(new FieldList(new int[]{6, 2}));
            Assert.assertTrue((boolean)req.isMetBy(gp2));
            GlobalProperties gp3 = new GlobalProperties();
            gp3.setAnyPartitioning(new FieldList(new int[]{6, 2, 4}));
            Assert.assertFalse((boolean)req.isMetBy(gp3));
            GlobalProperties gp4 = new GlobalProperties();
            gp4.setAnyPartitioning(new FieldList(new int[]{6, 1}));
            Assert.assertFalse((boolean)req.isMetBy(gp4));
            GlobalProperties gp5 = new GlobalProperties();
            gp5.setAnyPartitioning(new FieldList(2));
            Assert.assertTrue((boolean)req.isMetBy(gp5));
            gp1 = new GlobalProperties();
            gp1.setHashPartitioned(new FieldList(new int[]{2, 6}));
            Assert.assertTrue((boolean)req.isMetBy(gp1));
            gp2 = new GlobalProperties();
            gp2.setHashPartitioned(new FieldList(new int[]{6, 2}));
            Assert.assertTrue((boolean)req.isMetBy(gp2));
            gp3 = new GlobalProperties();
            gp3.setHashPartitioned(new FieldList(new int[]{6, 1}));
            Assert.assertFalse((boolean)req.isMetBy(gp3));
            gp1 = new GlobalProperties();
            gp1.setRangePartitioned(new Ordering(2, null, Order.DESCENDING).appendOrdering(Integer.valueOf(6), null, Order.ASCENDING));
            Assert.assertTrue((boolean)req.isMetBy(gp1));
            gp2 = new GlobalProperties();
            gp2.setRangePartitioned(new Ordering(6, null, Order.DESCENDING).appendOrdering(Integer.valueOf(2), null, Order.ASCENDING));
            Assert.assertTrue((boolean)req.isMetBy(gp2));
            gp3 = new GlobalProperties();
            gp3.setRangePartitioned(new Ordering(6, null, Order.DESCENDING).appendOrdering(Integer.valueOf(1), null, Order.ASCENDING));
            Assert.assertFalse((boolean)req.isMetBy(gp3));
            gp4 = new GlobalProperties();
            gp4.setRangePartitioned(new Ordering(6, null, Order.DESCENDING));
            Assert.assertTrue((boolean)req.isMetBy(gp4));
            gp1 = new GlobalProperties();
            gp1.setCustomPartitioned(new FieldList(new int[]{2, 6}), (Partitioner)new MockPartitioner());
            Assert.assertTrue((boolean)req.isMetBy(gp1));
            gp2 = new GlobalProperties();
            gp2.setCustomPartitioned(new FieldList(new int[]{6, 2}), (Partitioner)new MockPartitioner());
            Assert.assertTrue((boolean)req.isMetBy(gp2));
            gp3 = new GlobalProperties();
            gp3.setCustomPartitioned(new FieldList(new int[]{6, 1}), (Partitioner)new MockPartitioner());
            Assert.assertFalse((boolean)req.isMetBy(gp3));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMatchingCustomPartitioning() {
        try {
            MockPartitioner partitioner = new MockPartitioner();
            RequestedGlobalProperties req = new RequestedGlobalProperties();
            req.setCustomPartitioned(new FieldSet(new int[]{6, 2}), (Partitioner)partitioner);
            GlobalProperties gp1 = new GlobalProperties();
            gp1.setCustomPartitioned(new FieldList(new int[]{2, 6}), (Partitioner)partitioner);
            Assert.assertTrue((boolean)req.isMetBy(gp1));
            GlobalProperties gp2 = new GlobalProperties();
            gp2.setCustomPartitioned(new FieldList(new int[]{6, 2}), (Partitioner)partitioner);
            Assert.assertTrue((boolean)req.isMetBy(gp2));
            GlobalProperties gp3 = new GlobalProperties();
            gp3.setCustomPartitioned(new FieldList(new int[]{6, 2}), (Partitioner)new MockPartitioner());
            Assert.assertFalse((boolean)req.isMetBy(gp3));
            gp1 = new GlobalProperties();
            gp1.setAnyPartitioning(new FieldList(new int[]{6, 2}));
            Assert.assertFalse((boolean)req.isMetBy(gp1));
            gp2 = new GlobalProperties();
            gp2.setHashPartitioned(new FieldList(new int[]{6, 2}));
            Assert.assertFalse((boolean)req.isMetBy(gp2));
            gp3 = new GlobalProperties();
            gp3.setRangePartitioned(new Ordering(2, null, Order.DESCENDING).appendOrdering(Integer.valueOf(6), null, Order.ASCENDING));
            Assert.assertFalse((boolean)req.isMetBy(gp3));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStrictlyMatchingAnyPartitioning() {
        RequestedGlobalProperties req = new RequestedGlobalProperties();
        req.setAnyPartitioning((FieldSet)new FieldList(new int[]{6, 2}));
        GlobalProperties gp1 = new GlobalProperties();
        gp1.setAnyPartitioning(new FieldList(new int[]{6, 2}));
        Assert.assertTrue((boolean)req.isMetBy(gp1));
        GlobalProperties gp2 = new GlobalProperties();
        gp2.setAnyPartitioning(new FieldList(new int[]{2, 6}));
        Assert.assertFalse((boolean)req.isMetBy(gp2));
        GlobalProperties gp3 = new GlobalProperties();
        gp3.setAnyPartitioning(new FieldList(new int[]{6, 2, 3}));
        Assert.assertFalse((boolean)req.isMetBy(gp3));
        GlobalProperties gp4 = new GlobalProperties();
        gp4.setAnyPartitioning(new FieldList(new int[]{6, 1}));
        Assert.assertFalse((boolean)req.isMetBy(gp4));
        GlobalProperties gp5 = new GlobalProperties();
        gp5.setAnyPartitioning(new FieldList(2));
        Assert.assertFalse((boolean)req.isMetBy(gp5));
        gp1 = new GlobalProperties();
        gp1.setHashPartitioned(new FieldList(new int[]{6, 2}));
        Assert.assertTrue((boolean)req.isMetBy(gp1));
        gp2 = new GlobalProperties();
        gp2.setHashPartitioned(new FieldList(new int[]{2, 6}));
        Assert.assertFalse((boolean)req.isMetBy(gp2));
        gp3 = new GlobalProperties();
        gp3.setHashPartitioned(new FieldList(new int[]{6, 1}));
        Assert.assertFalse((boolean)req.isMetBy(gp3));
        gp1 = new GlobalProperties();
        gp1.setRangePartitioned(new Ordering(6, null, Order.DESCENDING).appendOrdering(Integer.valueOf(2), null, Order.ASCENDING));
        Assert.assertTrue((boolean)req.isMetBy(gp1));
        gp2 = new GlobalProperties();
        gp2.setRangePartitioned(new Ordering(2, null, Order.DESCENDING).appendOrdering(Integer.valueOf(6), null, Order.ASCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp2));
        gp3 = new GlobalProperties();
        gp3.setRangePartitioned(new Ordering(6, null, Order.DESCENDING).appendOrdering(Integer.valueOf(1), null, Order.ASCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp3));
        gp4 = new GlobalProperties();
        gp4.setRangePartitioned(new Ordering(6, null, Order.DESCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp4));
    }

    @Test
    public void testStrictlyMatchingHashPartitioning() {
        RequestedGlobalProperties req = new RequestedGlobalProperties();
        req.setHashPartitioned((FieldSet)new FieldList(new int[]{6, 2}));
        GlobalProperties gp1 = new GlobalProperties();
        gp1.setAnyPartitioning(new FieldList(new int[]{6, 2}));
        Assert.assertFalse((boolean)req.isMetBy(gp1));
        GlobalProperties gp2 = new GlobalProperties();
        gp2.setAnyPartitioning(new FieldList(new int[]{2, 6}));
        Assert.assertFalse((boolean)req.isMetBy(gp2));
        GlobalProperties gp3 = new GlobalProperties();
        gp3.setAnyPartitioning(new FieldList(new int[]{6, 1}));
        Assert.assertFalse((boolean)req.isMetBy(gp3));
        GlobalProperties gp4 = new GlobalProperties();
        gp4.setAnyPartitioning(new FieldList(2));
        Assert.assertFalse((boolean)req.isMetBy(gp4));
        gp1 = new GlobalProperties();
        gp1.setHashPartitioned(new FieldList(new int[]{6, 2}));
        Assert.assertTrue((boolean)req.isMetBy(gp1));
        gp2 = new GlobalProperties();
        gp2.setHashPartitioned(new FieldList(new int[]{2, 6}));
        Assert.assertFalse((boolean)req.isMetBy(gp2));
        gp3 = new GlobalProperties();
        gp3.setHashPartitioned(new FieldList(new int[]{6, 1}));
        Assert.assertFalse((boolean)req.isMetBy(gp3));
        gp4 = new GlobalProperties();
        gp4.setHashPartitioned(new FieldList(new int[]{6, 2, 0}));
        Assert.assertFalse((boolean)req.isMetBy(gp4));
        gp1 = new GlobalProperties();
        gp1.setRangePartitioned(new Ordering(6, null, Order.DESCENDING).appendOrdering(Integer.valueOf(2), null, Order.ASCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp1));
        gp2 = new GlobalProperties();
        gp2.setRangePartitioned(new Ordering(2, null, Order.DESCENDING).appendOrdering(Integer.valueOf(6), null, Order.ASCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp2));
        gp3 = new GlobalProperties();
        gp3.setRangePartitioned(new Ordering(6, null, Order.DESCENDING).appendOrdering(Integer.valueOf(1), null, Order.ASCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp3));
        gp4 = new GlobalProperties();
        gp4.setRangePartitioned(new Ordering(6, null, Order.DESCENDING));
        Assert.assertFalse((boolean)req.isMetBy(gp4));
    }
}

