/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.optimizer.operators.TestDistribution;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CoGroupWithDistributionTest
extends CompilerTestBase {
    @Test
    public void CoGroupWithSameDistributionTest() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource set1 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        DataSource set2 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        TestDistribution testDistribution1 = new TestDistribution(3);
        TestDistribution testDistribution2 = new TestDistribution(3);
        CoGroupOperator coGrouped = DataSetUtils.partitionByRange((DataSet)set1, (DataDistribution)testDistribution1, (int[])new int[]{0}).coGroup((DataSet)DataSetUtils.partitionByRange((DataSet)set2, (DataDistribution)testDistribution2, (int[])new int[]{0})).where(new int[]{0}).equalTo(new int[]{0}).with((CoGroupFunction)new CoGroupFunc());
        coGrouped.output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileWithStats(plan);
        SinkPlanNode sink = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        DualInputPlanNode coGroup = (DualInputPlanNode)sink.getInput().getSource();
        Channel input1 = coGroup.getInput1();
        Channel input2 = coGroup.getInput2();
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)input1.getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)input2.getShipStrategy());
    }

    @Test
    public void CoGroupWithDifferentDistributionTest() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource set1 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        DataSource set2 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        TestDistribution testDistribution1 = new TestDistribution(3);
        TestDistribution testDistribution2 = new TestDistribution(2);
        CoGroupOperator coGrouped = DataSetUtils.partitionByRange((DataSet)set1, (DataDistribution)testDistribution1, (int[])new int[]{0}).coGroup((DataSet)DataSetUtils.partitionByRange((DataSet)set2, (DataDistribution)testDistribution2, (int[])new int[]{0})).where(new int[]{0}).equalTo(new int[]{0}).with((CoGroupFunction)new CoGroupFunc());
        coGrouped.output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileWithStats(plan);
        SinkPlanNode sink = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        DualInputPlanNode coGroup = (DualInputPlanNode)sink.getInput().getSource();
        Channel input1 = coGroup.getInput1();
        Channel input2 = coGroup.getInput2();
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)input1.getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)input2.getShipStrategy());
    }

    public static class CoGroupFunc
    implements CoGroupFunction<Tuple3<Integer, Integer, Integer>, Tuple3<Integer, Integer, Integer>, Tuple3<Integer, Integer, Integer>> {
        public void coGroup(Iterable<Tuple3<Integer, Integer, Integer>> first, Iterable<Tuple3<Integer, Integer, Integer>> second, Collector<Tuple3<Integer, Integer, Integer>> out) throws Exception {
        }
    }
}

