/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.Iterator;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.operators.SortMergeInnerJoinDescriptor;
import org.apache.flink.optimizer.operators.TestDistribution;
import org.junit.Assert;
import org.junit.Test;

public class JoinGlobalPropertiesCompatibilityTest {
    @Test
    public void checkCompatiblePartitionings() {
        try {
            FieldList keysLeft = new FieldList(new int[]{1, 4});
            FieldList keysRight = new FieldList(new int[]{3, 1});
            SortMergeInnerJoinDescriptor descr = new SortMergeInnerJoinDescriptor(keysLeft, keysRight);
            RequestedGlobalProperties reqLeft = new RequestedGlobalProperties();
            reqLeft.setHashPartitioned((FieldSet)keysLeft);
            RequestedGlobalProperties reqRight = new RequestedGlobalProperties();
            reqRight.setHashPartitioned((FieldSet)keysRight);
            GlobalProperties propsLeft = new GlobalProperties();
            propsLeft.setHashPartitioned(keysLeft);
            GlobalProperties propsRight = new GlobalProperties();
            propsRight.setHashPartitioned(keysRight);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft, reqRight, propsLeft, propsRight));
            Object part = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            RequestedGlobalProperties reqLeft2 = new RequestedGlobalProperties();
            reqLeft2.setCustomPartitioned((FieldSet)keysLeft, (Partitioner)part);
            RequestedGlobalProperties reqRight2 = new RequestedGlobalProperties();
            reqRight2.setCustomPartitioned((FieldSet)keysRight, (Partitioner)part);
            Object propsLeft2 = new GlobalProperties();
            propsLeft2.setCustomPartitioned(keysLeft, (Partitioner)part);
            GlobalProperties propsRight2 = new GlobalProperties();
            propsRight2.setCustomPartitioned(keysRight, (Partitioner)part);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft2, reqRight2, (GlobalProperties)propsLeft2, propsRight2));
            part = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            reqLeft2 = new RequestedGlobalProperties();
            reqLeft2.setAnyPartitioning((FieldSet)keysLeft);
            reqRight2 = new RequestedGlobalProperties();
            reqRight2.setAnyPartitioning((FieldSet)keysRight);
            propsLeft2 = new GlobalProperties();
            propsLeft2.setCustomPartitioned(keysLeft, (Partitioner)part);
            propsRight2 = new GlobalProperties();
            propsRight2.setCustomPartitioned(keysRight, (Partitioner)part);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft2, reqRight2, (GlobalProperties)propsLeft2, propsRight2));
            TestDistribution dist1 = new TestDistribution(1);
            TestDistribution dist2 = new TestDistribution(1);
            Ordering ordering1 = new Ordering();
            propsLeft2 = keysLeft.iterator();
            while (propsLeft2.hasNext()) {
                int field = (Integer)propsLeft2.next();
                ordering1.appendOrdering(Integer.valueOf(field), null, Order.ASCENDING);
            }
            Ordering ordering2 = new Ordering();
            Iterator field = keysRight.iterator();
            while (field.hasNext()) {
                int field2 = (Integer)field.next();
                ordering2.appendOrdering(Integer.valueOf(field2), null, Order.ASCENDING);
            }
            RequestedGlobalProperties reqLeft3 = new RequestedGlobalProperties();
            reqLeft3.setRangePartitioned(ordering1, (DataDistribution)dist1);
            RequestedGlobalProperties reqRight3 = new RequestedGlobalProperties();
            reqRight3.setRangePartitioned(ordering2, (DataDistribution)dist2);
            GlobalProperties propsLeft3 = new GlobalProperties();
            propsLeft3.setRangePartitioned(ordering1, (DataDistribution)dist1);
            GlobalProperties propsRight3 = new GlobalProperties();
            propsRight3.setRangePartitioned(ordering2, (DataDistribution)dist2);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft3, reqRight3, propsLeft3, propsRight3));
            ordering1 = new Ordering();
            ordering1.appendOrdering(keysLeft.get(0), null, Order.DESCENDING);
            ordering1.appendOrdering(keysLeft.get(1), null, Order.ASCENDING);
            ordering2 = new Ordering();
            ordering2.appendOrdering(keysRight.get(0), null, Order.DESCENDING);
            ordering2.appendOrdering(keysRight.get(1), null, Order.ASCENDING);
            reqLeft3 = new RequestedGlobalProperties();
            reqLeft3.setRangePartitioned(ordering1, (DataDistribution)dist1);
            reqRight3 = new RequestedGlobalProperties();
            reqRight3.setRangePartitioned(ordering2, (DataDistribution)dist2);
            propsLeft3 = new GlobalProperties();
            propsLeft3.setRangePartitioned(ordering1, (DataDistribution)dist1);
            propsRight3 = new GlobalProperties();
            propsRight3.setRangePartitioned(ordering2, (DataDistribution)dist2);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft3, reqRight3, propsLeft3, propsRight3));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void checkInompatiblePartitionings() {
        try {
            FieldList keysLeft = new FieldList(1);
            FieldList keysRight = new FieldList(3);
            Partitioner<Object> part = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            Partitioner<Object> part2 = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            SortMergeInnerJoinDescriptor descr = new SortMergeInnerJoinDescriptor(keysLeft, keysRight);
            RequestedGlobalProperties reqLeft = new RequestedGlobalProperties();
            reqLeft.setAnyPartitioning((FieldSet)keysLeft);
            RequestedGlobalProperties reqRight = new RequestedGlobalProperties();
            reqRight.setAnyPartitioning((FieldSet)keysRight);
            GlobalProperties propsLeft = new GlobalProperties();
            propsLeft.setHashPartitioned(keysLeft);
            Object propsRight = new GlobalProperties();
            propsRight.setCustomPartitioned(keysRight, (Partitioner)part);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft, reqRight, propsLeft, (GlobalProperties)propsRight));
            reqLeft = new RequestedGlobalProperties();
            reqLeft.setAnyPartitioning((FieldSet)keysLeft);
            reqRight = new RequestedGlobalProperties();
            reqRight.setAnyPartitioning((FieldSet)keysRight);
            propsLeft = new GlobalProperties();
            propsLeft.setCustomPartitioned(keysLeft, (Partitioner)part);
            propsRight = new GlobalProperties();
            propsRight.setCustomPartitioned(keysRight, (Partitioner)part2);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft, reqRight, propsLeft, (GlobalProperties)propsRight));
            TestDistribution dist1 = new TestDistribution(1);
            TestDistribution dist2 = new TestDistribution(1);
            Ordering ordering1 = new Ordering();
            propsRight = keysLeft.iterator();
            while (propsRight.hasNext()) {
                int field = (Integer)propsRight.next();
                ordering1.appendOrdering(Integer.valueOf(field), null, Order.ASCENDING);
            }
            Object ordering2 = new Ordering();
            Iterator field = keysRight.iterator();
            while (field.hasNext()) {
                int field2 = (Integer)field.next();
                ordering1.appendOrdering(Integer.valueOf(field2), null, Order.ASCENDING);
                ordering2.appendOrdering(Integer.valueOf(field2), null, Order.ASCENDING);
            }
            RequestedGlobalProperties reqLeft2 = new RequestedGlobalProperties();
            reqLeft2.setRangePartitioned(ordering1, (DataDistribution)dist1);
            RequestedGlobalProperties reqRight2 = new RequestedGlobalProperties();
            reqRight2.setRangePartitioned((Ordering)ordering2, (DataDistribution)dist2);
            GlobalProperties propsLeft2 = new GlobalProperties();
            propsLeft2.setRangePartitioned(ordering1, (DataDistribution)dist1);
            GlobalProperties propsRight2 = new GlobalProperties();
            propsRight2.setRangePartitioned((Ordering)ordering2, (DataDistribution)dist2);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft2, reqRight2, propsLeft2, propsRight2));
            ordering1 = new Ordering();
            ordering2 = keysLeft.iterator();
            while (ordering2.hasNext()) {
                int field3 = (Integer)ordering2.next();
                ordering1.appendOrdering(Integer.valueOf(field3), null, Order.ASCENDING);
            }
            ordering2 = new Ordering();
            Iterator field3 = keysRight.iterator();
            while (field3.hasNext()) {
                int field4 = (Integer)field3.next();
                ordering2.appendOrdering(Integer.valueOf(field4), null, Order.DESCENDING);
            }
            reqLeft = new RequestedGlobalProperties();
            reqLeft.setRangePartitioned(ordering1, (DataDistribution)dist1);
            Object reqRight22 = new RequestedGlobalProperties();
            reqRight22.setRangePartitioned((Ordering)ordering2, (DataDistribution)dist2);
            propsLeft2 = new GlobalProperties();
            propsLeft2.setRangePartitioned(ordering1, (DataDistribution)dist1);
            propsRight2 = new GlobalProperties();
            propsRight2.setRangePartitioned((Ordering)ordering2, (DataDistribution)dist2);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft, (RequestedGlobalProperties)reqRight22, propsLeft2, propsRight2));
            TestDistribution dist3 = new TestDistribution(1);
            TestDistribution dist4 = new TestDistribution(2);
            Ordering ordering12 = new Ordering();
            reqRight22 = keysLeft.iterator();
            while (reqRight22.hasNext()) {
                int field5 = (Integer)reqRight22.next();
                ordering12.appendOrdering(Integer.valueOf(field5), null, Order.ASCENDING);
            }
            Ordering ordering22 = new Ordering();
            Iterator field5 = keysRight.iterator();
            while (field5.hasNext()) {
                int field6 = (Integer)field5.next();
                ordering22.appendOrdering(Integer.valueOf(field6), null, Order.ASCENDING);
            }
            RequestedGlobalProperties reqLeft3 = new RequestedGlobalProperties();
            reqLeft3.setRangePartitioned(ordering12, (DataDistribution)dist3);
            RequestedGlobalProperties reqRight3 = new RequestedGlobalProperties();
            reqRight3.setRangePartitioned(ordering22, (DataDistribution)dist4);
            GlobalProperties propsLeft3 = new GlobalProperties();
            propsLeft3.setRangePartitioned(ordering12, (DataDistribution)dist3);
            GlobalProperties propsRight3 = new GlobalProperties();
            propsRight3.setRangePartitioned(ordering22, (DataDistribution)dist4);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft3, reqRight3, propsLeft3, propsRight3));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

