/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.optimizer.operators.TestDistribution;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class JoinWithDistributionTest
extends CompilerTestBase {
    @Test
    public void JoinWithSameDistributionTest() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource set1 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        DataSource set2 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        TestDistribution dist1 = new TestDistribution(3);
        TestDistribution dist2 = new TestDistribution(3);
        JoinOperator.EquiJoin coGrouped = DataSetUtils.partitionByRange((DataSet)set1, (DataDistribution)dist1, (int[])new int[]{0}).join((DataSet)DataSetUtils.partitionByRange((DataSet)set2, (DataDistribution)dist2, (int[])new int[]{0})).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunc());
        coGrouped.output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileWithStats(plan);
        SinkPlanNode sink = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        DualInputPlanNode join = (DualInputPlanNode)sink.getInput().getSource();
        Channel input1 = join.getInput1();
        Channel input2 = join.getInput2();
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)input1.getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)input2.getShipStrategy());
    }

    @Test
    public void JoinWithDifferentDistributionTest() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource set1 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        DataSource set2 = env.readCsvFile(IN_FILE).types(Integer.class, Integer.class, Integer.class);
        TestDistribution dist1 = new TestDistribution(3);
        TestDistribution dist2 = new TestDistribution(4);
        JoinOperator.EquiJoin coGrouped = DataSetUtils.partitionByRange((DataSet)set1, (DataDistribution)dist1, (int[])new int[]{0}).join((DataSet)DataSetUtils.partitionByRange((DataSet)set2, (DataDistribution)dist2, (int[])new int[]{0})).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunc());
        coGrouped.output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        OptimizedPlan oPlan = this.compileWithStats(plan);
        SinkPlanNode sink = (SinkPlanNode)oPlan.getDataSinks().iterator().next();
        DualInputPlanNode join = (DualInputPlanNode)sink.getInput().getSource();
        Channel input1 = join.getInput1();
        Channel input2 = join.getInput2();
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)input1.getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)input2.getShipStrategy());
    }

    public static class JoinFunc
    implements JoinFunction<Tuple3<Integer, Integer, Integer>, Tuple3<Integer, Integer, Integer>, Tuple3<Integer, Integer, Integer>> {
        public Tuple3<Integer, Integer, Integer> join(Tuple3<Integer, Integer, Integer> first, Tuple3<Integer, Integer, Integer> second) throws Exception {
            return null;
        }
    }
}

