/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plandump;

import java.io.Serializable;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionPlanUtil;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Test;

public class ExecutionPlanUtilTest {
    @Test
    public void executionPlanCanBeRetrieved() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(8);
        ((MapOperator)((MapOperator)((DataSource)env.readCsvFile("file:///will/never/be/executed").types(String.class, Double.class).name("sourceThatWillNotRun")).map((MapFunction & Serializable)in -> in).returns((TypeHint)new TypeHint<Tuple2<String, Double>>(){})).name("theMap")).writeAsText("file:///will/not/be/executed").name("sinkThatWillNotRun");
        Plan plan = env.createProgramPlan();
        String executionPlanAsJSON = ExecutionPlanUtil.getExecutionPlanAsJSON((Plan)plan);
        MatcherAssert.assertThat((Object)executionPlanAsJSON, (Matcher)StringContains.containsString((String)"sourceThatWillNotRun"));
        MatcherAssert.assertThat((Object)executionPlanAsJSON, (Matcher)StringContains.containsString((String)"sinkThatWillNotRun"));
        MatcherAssert.assertThat((Object)executionPlanAsJSON, (Matcher)StringContains.containsString((String)"theMap"));
    }
}

