/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plantranslate;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.optimizer.testfunctions.DummyFlatJoinFunction;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.junit.Assert;
import org.junit.Test;

public class TempInIterationsTest {
    @Test
    public void testTempInIterationTest() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.readCsvFile("file:///does/not/exist").types(Long.class, Long.class);
        DeltaIteration iteration = input.iterateDelta((DataSet)input, 1, new int[]{0});
        JoinOperator.EquiJoin update = iteration.getWorkset().join((DataSet)iteration.getSolutionSet()).where(new int[]{0}).equalTo(new int[]{0}).with(new DummyFlatJoinFunction());
        iteration.closeWith((DataSet)update, (DataSet)update).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        OptimizedPlan oPlan = new Optimizer(new Configuration()).compile(plan);
        JobGraphGenerator jgg = new JobGraphGenerator();
        JobGraph jg = jgg.compileJobGraph(oPlan);
        boolean solutionSetUpdateChecked = false;
        for (JobVertex v : jg.getVertices()) {
            if (!v.getName().equals("SolutionSet Delta")) continue;
            TaskConfig tc = new TaskConfig(v.getConfiguration());
            Assert.assertTrue((boolean)tc.isInputAsynchronouslyMaterialized(0));
            solutionSetUpdateChecked = true;
        }
        Assert.assertTrue((boolean)solutionSetUpdateChecked);
    }
}

