/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import java.util.Arrays;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.CreditBasedInputBuffersUsageGauge;
import org.apache.flink.runtime.io.network.metrics.ExclusiveBuffersUsageGauge;
import org.apache.flink.runtime.io.network.metrics.FloatingBuffersUsageGauge;
import org.apache.flink.runtime.io.network.metrics.InputBuffersGauge;
import org.apache.flink.runtime.io.network.metrics.InputGateMetrics;
import org.apache.flink.runtime.io.network.metrics.OutputBufferPoolUsageGauge;
import org.apache.flink.runtime.io.network.metrics.OutputBuffersGauge;
import org.apache.flink.runtime.io.network.metrics.ResultPartitionMetrics;
import org.apache.flink.runtime.io.network.metrics.TimeToConsumeGauge;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class NettyShuffleMetricFactory {
    @Deprecated
    private static final String METRIC_GROUP_NETWORK_DEPRECATED = "Network";
    @Deprecated
    private static final String METRIC_GROUP_BUFFERS_DEPRECATED = "buffers";
    private static final String METRIC_TOTAL_MEMORY_SEGMENT = "TotalMemorySegments";
    private static final String METRIC_TOTAL_MEMORY = "TotalMemory";
    private static final String METRIC_AVAILABLE_MEMORY_SEGMENT = "AvailableMemorySegments";
    private static final String METRIC_AVAILABLE_MEMORY = "AvailableMemory";
    private static final String METRIC_USED_MEMORY_SEGMENT = "UsedMemorySegments";
    private static final String METRIC_USED_MEMORY = "UsedMemory";
    private static final String METRIC_GROUP_SHUFFLE = "Shuffle";
    private static final String METRIC_GROUP_NETTY = "Netty";
    public static final String METRIC_GROUP_OUTPUT = "Output";
    public static final String METRIC_GROUP_INPUT = "Input";
    private static final String METRIC_GROUP_BUFFERS = "Buffers";
    private static final String METRIC_OUTPUT_QUEUE_LENGTH = "outputQueueLength";
    private static final String METRIC_OUTPUT_POOL_USAGE = "outPoolUsage";
    private static final String METRIC_INPUT_QUEUE_LENGTH = "inputQueueLength";
    private static final String METRIC_INPUT_POOL_USAGE = "inPoolUsage";
    private static final String METRIC_INPUT_FLOATING_BUFFERS_USAGE = "inputFloatingBuffersUsage";
    private static final String METRIC_INPUT_EXCLUSIVE_BUFFERS_USAGE = "inputExclusiveBuffersUsage";

    private NettyShuffleMetricFactory() {
    }

    public static void registerShuffleMetrics(MetricGroup metricGroup, NetworkBufferPool networkBufferPool) {
        Preconditions.checkNotNull((Object)metricGroup);
        Preconditions.checkNotNull((Object)networkBufferPool);
        NettyShuffleMetricFactory.internalRegisterDeprecatedNetworkMetrics(metricGroup, networkBufferPool);
        NettyShuffleMetricFactory.internalRegisterShuffleMetrics(metricGroup, networkBufferPool);
    }

    @Deprecated
    private static void internalRegisterDeprecatedNetworkMetrics(MetricGroup parentMetricGroup, NetworkBufferPool networkBufferPool) {
        MetricGroup networkGroup = parentMetricGroup.addGroup(METRIC_GROUP_NETWORK_DEPRECATED);
        networkGroup.gauge(METRIC_TOTAL_MEMORY_SEGMENT, networkBufferPool::getTotalNumberOfMemorySegments);
        networkGroup.gauge(METRIC_AVAILABLE_MEMORY_SEGMENT, networkBufferPool::getNumberOfAvailableMemorySegments);
    }

    private static void internalRegisterShuffleMetrics(MetricGroup parentMetricGroup, NetworkBufferPool networkBufferPool) {
        MetricGroup shuffleGroup = parentMetricGroup.addGroup(METRIC_GROUP_SHUFFLE);
        MetricGroup networkGroup = shuffleGroup.addGroup(METRIC_GROUP_NETTY);
        networkGroup.gauge(METRIC_TOTAL_MEMORY_SEGMENT, networkBufferPool::getTotalNumberOfMemorySegments);
        networkGroup.gauge(METRIC_TOTAL_MEMORY, networkBufferPool::getTotalMemory);
        networkGroup.gauge(METRIC_AVAILABLE_MEMORY_SEGMENT, networkBufferPool::getNumberOfAvailableMemorySegments);
        networkGroup.gauge(METRIC_AVAILABLE_MEMORY, networkBufferPool::getAvailableMemory);
        networkGroup.gauge(METRIC_USED_MEMORY_SEGMENT, networkBufferPool::getNumberOfUsedMemorySegments);
        networkGroup.gauge(METRIC_USED_MEMORY, networkBufferPool::getUsedMemory);
    }

    public static MetricGroup createShuffleIOOwnerMetricGroup(MetricGroup parentGroup) {
        return parentGroup.addGroup(METRIC_GROUP_SHUFFLE).addGroup(METRIC_GROUP_NETTY);
    }

    @Deprecated
    public static void registerLegacyNetworkMetrics(boolean isDetailedMetrics, MetricGroup metricGroup, ResultPartitionWriter[] producedPartitions, InputGate[] inputGates) {
        Preconditions.checkNotNull((Object)metricGroup);
        Preconditions.checkNotNull((Object)producedPartitions);
        Preconditions.checkNotNull((Object)inputGates);
        MetricGroup buffersGroup = metricGroup.addGroup(METRIC_GROUP_BUFFERS_DEPRECATED);
        MetricGroup networkGroup = metricGroup.addGroup(METRIC_GROUP_NETWORK_DEPRECATED);
        MetricGroup outputGroup = networkGroup.addGroup(METRIC_GROUP_OUTPUT);
        MetricGroup inputGroup = networkGroup.addGroup(METRIC_GROUP_INPUT);
        ResultPartition[] resultPartitions = (ResultPartition[])Arrays.copyOf(producedPartitions, producedPartitions.length, ResultPartition[].class);
        NettyShuffleMetricFactory.registerOutputMetrics(isDetailedMetrics, outputGroup, buffersGroup, resultPartitions);
        SingleInputGate[] singleInputGates = (SingleInputGate[])Arrays.copyOf(inputGates, inputGates.length, SingleInputGate[].class);
        NettyShuffleMetricFactory.registerInputMetrics(isDetailedMetrics, inputGroup, buffersGroup, singleInputGates);
    }

    public static void registerOutputMetrics(boolean isDetailedMetrics, MetricGroup outputGroup, ResultPartition[] resultPartitions) {
        NettyShuffleMetricFactory.registerOutputMetrics(isDetailedMetrics, outputGroup, outputGroup.addGroup(METRIC_GROUP_BUFFERS), resultPartitions);
    }

    private static void registerOutputMetrics(boolean isDetailedMetrics, MetricGroup outputGroup, MetricGroup buffersGroup, ResultPartition[] resultPartitions) {
        if (isDetailedMetrics) {
            ResultPartitionMetrics.registerQueueLengthMetrics(outputGroup, resultPartitions);
        }
        buffersGroup.gauge(METRIC_OUTPUT_QUEUE_LENGTH, (Gauge)new OutputBuffersGauge(resultPartitions));
        buffersGroup.gauge(METRIC_OUTPUT_POOL_USAGE, (Gauge)new OutputBufferPoolUsageGauge(resultPartitions));
    }

    public static void registerInputMetrics(boolean isDetailedMetrics, MetricGroup inputGroup, SingleInputGate[] inputGates) {
        NettyShuffleMetricFactory.registerInputMetrics(isDetailedMetrics, inputGroup, inputGroup.addGroup(METRIC_GROUP_BUFFERS), inputGates);
    }

    private static void registerInputMetrics(boolean isDetailedMetrics, MetricGroup inputGroup, MetricGroup buffersGroup, SingleInputGate[] inputGates) {
        if (isDetailedMetrics) {
            InputGateMetrics.registerQueueLengthMetrics(inputGroup, inputGates);
        }
        buffersGroup.gauge(METRIC_INPUT_QUEUE_LENGTH, (Gauge)new InputBuffersGauge(inputGates));
        FloatingBuffersUsageGauge floatingBuffersUsageGauge = new FloatingBuffersUsageGauge(inputGates);
        ExclusiveBuffersUsageGauge exclusiveBuffersUsageGauge = new ExclusiveBuffersUsageGauge(inputGates);
        CreditBasedInputBuffersUsageGauge creditBasedInputBuffersUsageGauge = new CreditBasedInputBuffersUsageGauge(floatingBuffersUsageGauge, exclusiveBuffersUsageGauge, inputGates);
        buffersGroup.gauge(METRIC_INPUT_EXCLUSIVE_BUFFERS_USAGE, (Gauge)exclusiveBuffersUsageGauge);
        buffersGroup.gauge(METRIC_INPUT_FLOATING_BUFFERS_USAGE, (Gauge)floatingBuffersUsageGauge);
        buffersGroup.gauge(METRIC_INPUT_POOL_USAGE, (Gauge)creditBasedInputBuffersUsageGauge);
    }

    public static void registerDebloatingTaskMetrics(SingleInputGate[] inputGates, MetricGroup taskGroup) {
        taskGroup.gauge("estimatedTimeToConsumeBuffersMs", (Gauge)new TimeToConsumeGauge(inputGates));
    }
}

