/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultPartition
implements ResultPartitionWriter {
    protected static final Logger LOG = LoggerFactory.getLogger(ResultPartition.class);
    private final String owningTaskName;
    private final int partitionIndex;
    protected final ResultPartitionID partitionId;
    protected final ResultPartitionType partitionType;
    protected final ResultPartitionManager partitionManager;
    protected final int numSubpartitions;
    private final int numTargetKeyGroups;
    private final AtomicBoolean isReleased = new AtomicBoolean();
    protected BufferPool bufferPool;
    private boolean isFinished;
    private volatile Throwable cause;
    private final SupplierWithException<BufferPool, IOException> bufferPoolFactory;
    @Nullable
    protected final BufferCompressor bufferCompressor;
    protected Counter numBytesOut = new SimpleCounter();
    protected Counter numBuffersOut = new SimpleCounter();
    protected Counter numBytesProduced = new SimpleCounter();

    public ResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, int numSubpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, SupplierWithException<BufferPool, IOException> bufferPoolFactory) {
        this.owningTaskName = (String)Preconditions.checkNotNull((Object)owningTaskName);
        Preconditions.checkArgument((0 <= partitionIndex ? 1 : 0) != 0, (Object)"The partition index must be positive.");
        this.partitionIndex = partitionIndex;
        this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.numSubpartitions = numSubpartitions;
        this.numTargetKeyGroups = numTargetKeyGroups;
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.bufferCompressor = bufferCompressor;
        this.bufferPoolFactory = bufferPoolFactory;
    }

    @Override
    public void setup() throws IOException {
        Preconditions.checkState((this.bufferPool == null ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Already registered buffer pool.");
        this.bufferPool = (BufferPool)Preconditions.checkNotNull((Object)this.bufferPoolFactory.get());
        this.partitionManager.registerResultPartition(this);
    }

    public String getOwningTaskName() {
        return this.owningTaskName;
    }

    @Override
    public ResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    @Override
    public int getNumberOfSubpartitions() {
        return this.numSubpartitions;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public abstract int getNumberOfQueuedBuffers();

    public abstract int getNumberOfQueuedBuffers(int var1);

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    @Override
    public void notifyEndOfData() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> getAllDataProcessedFuture() {
        throw new UnsupportedOperationException();
    }

    public void onSubpartitionAllDataProcessed(int subpartition) {
    }

    @Override
    public void finish() throws IOException {
        this.checkInProduceState();
        this.isFinished = true;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    public void release() {
        this.release(null);
    }

    @Override
    public void release(Throwable cause) {
        if (this.isReleased.compareAndSet(false, true)) {
            LOG.debug("{}: Releasing {}.", (Object)this.owningTaskName, (Object)this);
            if (cause != null) {
                this.cause = cause;
            }
            this.releaseInternal();
        }
    }

    protected abstract void releaseInternal();

    private void closeBufferPool() {
        if (this.bufferPool != null) {
            this.bufferPool.lazyDestroy();
        }
    }

    @Override
    public void close() {
        this.closeBufferPool();
    }

    @Override
    public void fail(@Nullable Throwable throwable) {
        this.closeBufferPool();
        this.partitionManager.releasePartition(this.partitionId, throwable);
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    @Override
    public int getNumTargetKeyGroups() {
        return this.numTargetKeyGroups;
    }

    @Override
    public void setMetricGroup(TaskIOMetricGroup metrics) {
        this.numBytesOut = metrics.getNumBytesOutCounter();
        this.numBuffersOut = metrics.getNumBuffersOutCounter();
        metrics.registerNumBytesProducedCounterForPartition(this.partitionId.getPartitionId(), this.numBytesProduced);
    }

    @Override
    public boolean isReleased() {
        return this.isReleased.get();
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.bufferPool.getAvailableFuture();
    }

    public String toString() {
        return "ResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.numSubpartitions + " subpartitions]";
    }

    void onConsumedSubpartition(int subpartitionIndex) {
        if (this.isReleased.get()) {
            return;
        }
        LOG.debug("{}: Received release notification for subpartition {}.", (Object)this, (Object)subpartitionIndex);
    }

    protected void checkInProduceState() throws IllegalStateException {
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Partition already finished.");
    }

    @VisibleForTesting
    public ResultPartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    protected boolean canBeCompressed(Buffer buffer) {
        return this.bufferCompressor != null && buffer.isBuffer() && buffer.readableBytes() > 0;
    }
}

