/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.client.ClientUtils;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.TriggerSavepointMode;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServicesWithLeadershipControl;
import org.apache.flink.runtime.highavailability.nonha.embedded.HaLeadershipControl;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.webmonitor.retriever.LeaderRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcGatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcMetricQueryServiceRetriever;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.ExponentialBackoffRetryStrategy;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.apache.flink.util.function.FunctionUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniCluster
implements AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(MiniCluster.class);
    private final Object lock = new Object();
    private final MiniClusterConfiguration miniClusterConfiguration;
    private final Time rpcTimeout;
    @GuardedBy(value="lock")
    private final List<TaskExecutor> taskManagers;
    private final TerminatingFatalErrorHandlerFactory taskManagerTerminatingFatalErrorHandlerFactory = new TerminatingFatalErrorHandlerFactory();
    private CompletableFuture<Void> terminationFuture;
    @GuardedBy(value="lock")
    private MetricRegistryImpl metricRegistry;
    @GuardedBy(value="lock")
    private ProcessMetricGroup processMetricGroup;
    @GuardedBy(value="lock")
    private RpcService commonRpcService;
    @GuardedBy(value="lock")
    private ExecutorService ioExecutor;
    @GuardedBy(value="lock")
    private final Collection<RpcService> rpcServices;
    @GuardedBy(value="lock")
    private HighAvailabilityServices haServices;
    @GuardedBy(value="lock")
    private BlobServer blobServer;
    @GuardedBy(value="lock")
    private HeartbeatServices heartbeatServices;
    @GuardedBy(value="lock")
    private BlobCacheService blobCacheService;
    @GuardedBy(value="lock")
    private LeaderRetrievalService resourceManagerLeaderRetriever;
    @GuardedBy(value="lock")
    private LeaderRetrievalService dispatcherLeaderRetriever;
    @GuardedBy(value="lock")
    private LeaderRetrievalService clusterRestEndpointLeaderRetrievalService;
    @GuardedBy(value="lock")
    private Collection<DispatcherResourceManagerComponent> dispatcherResourceManagerComponents;
    @GuardedBy(value="lock")
    private RpcGatewayRetriever<DispatcherId, DispatcherGateway> dispatcherGatewayRetriever;
    @GuardedBy(value="lock")
    private RpcGatewayRetriever<ResourceManagerId, ResourceManagerGateway> resourceManagerGatewayRetriever;
    @GuardedBy(value="lock")
    private LeaderRetriever webMonitorLeaderRetriever;
    @GuardedBy(value="lock")
    private RpcServiceFactory taskManagerRpcServiceFactory;
    private volatile boolean running;
    @GuardedBy(value="lock")
    private RpcSystem rpcSystem;

    public MiniCluster(MiniClusterConfiguration miniClusterConfiguration) {
        this.miniClusterConfiguration = (MiniClusterConfiguration)Preconditions.checkNotNull((Object)miniClusterConfiguration, (String)"config may not be null");
        this.rpcServices = new ArrayList<RpcService>(3 + miniClusterConfiguration.getNumTaskManagers());
        this.dispatcherResourceManagerComponents = new ArrayList<DispatcherResourceManagerComponent>(1);
        this.rpcTimeout = RpcUtils.INF_TIMEOUT;
        this.terminationFuture = CompletableFuture.completedFuture(null);
        this.running = false;
        this.taskManagers = new ArrayList<TaskExecutor>(miniClusterConfiguration.getNumTaskManagers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<URI> getRestAddress() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.running, (Object)"MiniCluster is not yet running or has already been shut down.");
            return this.webMonitorLeaderRetriever.getLeaderFuture().thenApply(FunctionUtils.uncheckedFunction(addressLeaderIdTuple -> new URI((String)addressLeaderIdTuple.f0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterInformation getClusterInformation() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.running, (Object)"MiniCluster is not yet running or has already been shut down.");
            return new ClusterInformation("localhost", this.blobServer.getPort());
        }
    }

    protected Executor getIOExecutor() {
        return this.ioExecutor;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.running ? 1 : 0) != 0, (Object)"MiniCluster is already running");
            LOG.info("Starting Flink Mini Cluster");
            LOG.debug("Using configuration {}", (Object)this.miniClusterConfiguration);
            UnmodifiableConfiguration configuration = this.miniClusterConfiguration.getConfiguration();
            boolean useSingleRpcService = this.miniClusterConfiguration.getRpcServiceSharing() == RpcServiceSharing.SHARED;
            try {
                RpcService metricQueryServiceRpcService;
                RpcServiceFactory dispatcherResourceManagerComponentRpcServiceFactory;
                this.initializeIOFormatClasses((Configuration)configuration);
                this.rpcSystem = RpcSystem.load((Configuration)configuration);
                LOG.info("Starting Metrics Registry");
                this.metricRegistry = this.createMetricRegistry((Configuration)configuration, this.rpcSystem.getMaximumMessageSizeInBytes((Configuration)configuration));
                LOG.info("Starting RPC Service(s)");
                if (useSingleRpcService) {
                    this.commonRpcService = this.createLocalRpcService((Configuration)configuration, this.rpcSystem);
                    CommonRpcServiceFactory commonRpcServiceFactory = new CommonRpcServiceFactory(this.commonRpcService);
                    this.taskManagerRpcServiceFactory = commonRpcServiceFactory;
                    dispatcherResourceManagerComponentRpcServiceFactory = commonRpcServiceFactory;
                    metricQueryServiceRpcService = MetricUtils.startLocalMetricsRpcService((Configuration)configuration, this.rpcSystem);
                } else {
                    String jobManagerExternalAddress = this.miniClusterConfiguration.getJobManagerExternalAddress();
                    String taskManagerExternalAddress = this.miniClusterConfiguration.getTaskManagerExternalAddress();
                    String jobManagerExternalPortRange = this.miniClusterConfiguration.getJobManagerExternalPortRange();
                    String taskManagerExternalPortRange = this.miniClusterConfiguration.getTaskManagerExternalPortRange();
                    String jobManagerBindAddress = this.miniClusterConfiguration.getJobManagerBindAddress();
                    String taskManagerBindAddress = this.miniClusterConfiguration.getTaskManagerBindAddress();
                    dispatcherResourceManagerComponentRpcServiceFactory = new DedicatedRpcServiceFactory((Configuration)configuration, jobManagerExternalAddress, jobManagerExternalPortRange, jobManagerBindAddress, this.rpcSystem);
                    this.taskManagerRpcServiceFactory = new DedicatedRpcServiceFactory((Configuration)configuration, taskManagerExternalAddress, taskManagerExternalPortRange, taskManagerBindAddress, this.rpcSystem);
                    this.commonRpcService = this.createRemoteRpcService((Configuration)configuration, jobManagerBindAddress, 0, this.rpcSystem);
                    metricQueryServiceRpcService = MetricUtils.startRemoteMetricsRpcService((Configuration)configuration, this.commonRpcService.getAddress(), this.rpcSystem);
                }
                this.metricRegistry.startQueryService(metricQueryServiceRpcService, null);
                this.processMetricGroup = MetricUtils.instantiateProcessMetricGroup(this.metricRegistry, RpcUtils.getHostname((RpcService)this.commonRpcService), ConfigurationUtils.getSystemResourceMetricsProbingInterval((Configuration)configuration));
                this.ioExecutor = Executors.newFixedThreadPool(ClusterEntrypointUtils.getPoolSize((Configuration)configuration), (ThreadFactory)new ExecutorThreadFactory("mini-cluster-io"));
                this.haServices = this.createHighAvailabilityServices((Configuration)configuration, this.ioExecutor);
                this.blobServer = new BlobServer((Configuration)configuration, this.haServices.createBlobStore());
                this.blobServer.start();
                this.heartbeatServices = HeartbeatServices.fromConfiguration((Configuration)configuration);
                this.blobCacheService = new BlobCacheService((Configuration)configuration, this.haServices.createBlobStore(), new InetSocketAddress(InetAddress.getLocalHost(), this.blobServer.getPort()));
                this.startTaskManagers();
                RpcMetricQueryServiceRetriever metricQueryServiceRetriever = new RpcMetricQueryServiceRetriever(this.metricRegistry.getMetricQueryServiceRpcService());
                this.setupDispatcherResourceManagerComponents((Configuration)configuration, dispatcherResourceManagerComponentRpcServiceFactory, metricQueryServiceRetriever);
                this.resourceManagerLeaderRetriever = this.haServices.getResourceManagerLeaderRetriever();
                this.dispatcherLeaderRetriever = this.haServices.getDispatcherLeaderRetriever();
                this.clusterRestEndpointLeaderRetrievalService = this.haServices.getClusterRestEndpointLeaderRetriever();
                this.dispatcherGatewayRetriever = new RpcGatewayRetriever<DispatcherId, DispatcherGateway>(this.commonRpcService, DispatcherGateway.class, DispatcherId::fromUuid, (RetryStrategy)new ExponentialBackoffRetryStrategy(21, Duration.ofMillis(5L), Duration.ofMillis(20L)));
                this.resourceManagerGatewayRetriever = new RpcGatewayRetriever<ResourceManagerId, ResourceManagerGateway>(this.commonRpcService, ResourceManagerGateway.class, ResourceManagerId::fromUuid, (RetryStrategy)new ExponentialBackoffRetryStrategy(21, Duration.ofMillis(5L), Duration.ofMillis(20L)));
                this.webMonitorLeaderRetriever = new LeaderRetriever();
                this.resourceManagerLeaderRetriever.start(this.resourceManagerGatewayRetriever);
                this.dispatcherLeaderRetriever.start(this.dispatcherGatewayRetriever);
                this.clusterRestEndpointLeaderRetrievalService.start(this.webMonitorLeaderRetriever);
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception ee) {
                    e.addSuppressed(ee);
                }
                throw e;
            }
            this.terminationFuture = new CompletableFuture();
            this.running = true;
            LOG.info("Flink Mini Cluster started successfully");
        }
    }

    @GuardedBy(value="lock")
    private void setupDispatcherResourceManagerComponents(Configuration configuration, RpcServiceFactory dispatcherResourceManagerComponentRpcServiceFactory, MetricQueryServiceRetriever metricQueryServiceRetriever) throws Exception {
        this.dispatcherResourceManagerComponents.addAll(this.createDispatcherResourceManagerComponents(configuration, dispatcherResourceManagerComponentRpcServiceFactory, this.haServices, this.blobServer, this.heartbeatServices, this.metricRegistry, metricQueryServiceRetriever, new ShutDownFatalErrorHandler()));
        ArrayList<CompletableFuture<ApplicationStatus>> shutDownFutures = new ArrayList<CompletableFuture<ApplicationStatus>>(this.dispatcherResourceManagerComponents.size());
        for (DispatcherResourceManagerComponent dispatcherResourceManagerComponent : this.dispatcherResourceManagerComponents) {
            CompletableFuture<ApplicationStatus> shutDownFuture = dispatcherResourceManagerComponent.getShutDownFuture();
            FutureUtils.assertNoException((CompletableFuture)shutDownFuture.thenRun(dispatcherResourceManagerComponent::closeAsync));
            shutDownFutures.add(shutDownFuture);
        }
        FutureUtils.assertNoException((CompletableFuture)FutureUtils.completeAll(shutDownFutures).thenRun(this::closeAsync));
    }

    @VisibleForTesting
    protected Collection<? extends DispatcherResourceManagerComponent> createDispatcherResourceManagerComponents(Configuration configuration, RpcServiceFactory rpcServiceFactory, HighAvailabilityServices haServices, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, MetricQueryServiceRetriever metricQueryServiceRetriever, FatalErrorHandler fatalErrorHandler) throws Exception {
        DispatcherResourceManagerComponentFactory dispatcherResourceManagerComponentFactory = this.createDispatcherResourceManagerComponentFactory();
        return Collections.singleton(dispatcherResourceManagerComponentFactory.create(configuration, this.ioExecutor, rpcServiceFactory.createRpcService(), haServices, blobServer, heartbeatServices, metricRegistry, new MemoryExecutionGraphInfoStore(), metricQueryServiceRetriever, fatalErrorHandler));
    }

    @Nonnull
    DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory() {
        return DefaultDispatcherResourceManagerComponentFactory.createSessionComponentFactory(StandaloneResourceManagerFactory.getInstance());
    }

    @VisibleForTesting
    protected HighAvailabilityServices createHighAvailabilityServices(Configuration configuration, Executor executor) throws Exception {
        LOG.info("Starting high-availability services");
        HaServices haServices = this.miniClusterConfiguration.getHaServices();
        switch (haServices) {
            case WITH_LEADERSHIP_CONTROL: {
                return new EmbeddedHaServicesWithLeadershipControl(executor);
            }
            case CONFIGURED: {
                return HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices(configuration, executor, new ShutDownFatalErrorHandler());
            }
        }
        throw new IllegalConfigurationException("Unknown HA Services " + (Object)((Object)haServices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<HaLeadershipControl> getHaLeadershipControl() {
        Object object = this.lock;
        synchronized (object) {
            return this.haServices instanceof HaLeadershipControl ? Optional.of((HaLeadershipControl)((Object)this.haServices)) : Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                LOG.info("Shutting down Flink Mini Cluster");
                try {
                    long shutdownTimeoutMillis = this.miniClusterConfiguration.getConfiguration().getLong(ClusterOptions.CLUSTER_SERVICES_SHUTDOWN_TIMEOUT);
                    int numComponents = 2 + this.miniClusterConfiguration.getNumTaskManagers();
                    ArrayList<CompletableFuture<Void>> componentTerminationFutures = new ArrayList<CompletableFuture<Void>>(numComponents);
                    componentTerminationFutures.addAll(this.terminateTaskManagers());
                    componentTerminationFutures.add(this.shutDownResourceManagerComponents());
                    FutureUtils.ConjunctFuture componentsTerminationFuture = FutureUtils.completeAll(componentTerminationFutures);
                    CompletableFuture metricSystemTerminationFuture = FutureUtils.composeAfterwards((CompletableFuture)componentsTerminationFuture, this::closeMetricSystem);
                    CompletableFuture rpcServicesTerminationFuture = FutureUtils.composeAfterwards((CompletableFuture)metricSystemTerminationFuture, this::terminateRpcServices);
                    CompletableFuture remainingServicesTerminationFuture = FutureUtils.runAfterwards((CompletableFuture)rpcServicesTerminationFuture, this::terminateMiniClusterServices);
                    CompletableFuture executorsTerminationFuture = FutureUtils.composeAfterwards((CompletableFuture)remainingServicesTerminationFuture, () -> this.terminateExecutors(shutdownTimeoutMillis));
                    executorsTerminationFuture.whenComplete((ignored, throwable) -> {
                        if (throwable != null) {
                            this.terminationFuture.completeExceptionally(ExceptionUtils.stripCompletionException((Throwable)throwable));
                        } else {
                            this.terminationFuture.complete(null);
                        }
                    });
                }
                finally {
                    this.running = false;
                }
            }
            return this.terminationFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeMetricSystem() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CompletableFuture<Void>> terminationFutures = new ArrayList<CompletableFuture<Void>>(2);
            if (this.processMetricGroup != null) {
                this.processMetricGroup.close();
                this.processMetricGroup = null;
            }
            if (this.metricRegistry != null) {
                terminationFutures.add(this.metricRegistry.shutdown());
                this.metricRegistry = null;
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    @GuardedBy(value="lock")
    private void startTaskManagers() throws Exception {
        int numTaskManagers = this.miniClusterConfiguration.getNumTaskManagers();
        LOG.info("Starting {} TaskManager(s)", (Object)numTaskManagers);
        for (int i = 0; i < numTaskManagers; ++i) {
            this.startTaskManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTaskManager() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            UnmodifiableConfiguration configuration = this.miniClusterConfiguration.getConfiguration();
            TaskExecutor taskExecutor = TaskManagerRunner.startTaskManager((Configuration)configuration, new ResourceID(UUID.randomUUID().toString()), this.taskManagerRpcServiceFactory.createRpcService(), this.haServices, this.heartbeatServices, this.metricRegistry, this.blobCacheService, this.useLocalCommunication(), ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES, this.taskManagerTerminatingFatalErrorHandlerFactory.create(this.taskManagers.size()));
            taskExecutor.start();
            this.taskManagers.add(taskExecutor);
        }
    }

    @VisibleForTesting
    protected boolean useLocalCommunication() {
        return this.miniClusterConfiguration.getNumTaskManagers() == 1;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.miniClusterConfiguration.getConfiguration();
    }

    @GuardedBy(value="lock")
    private Collection<? extends CompletableFuture<Void>> terminateTaskManagers() {
        ArrayList<CompletableFuture<Void>> terminationFutures = new ArrayList<CompletableFuture<Void>>(this.taskManagers.size());
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            terminationFutures.add(this.terminateTaskManager(i));
        }
        return terminationFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> terminateTaskManager(int index) {
        Object object = this.lock;
        synchronized (object) {
            TaskExecutor taskExecutor = this.taskManagers.get(index);
            return taskExecutor.closeAsync();
        }
    }

    public CompletableFuture<ArchivedExecutionGraph> getArchivedExecutionGraph(JobID jobId) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.requestExecutionGraphInfo(jobId, this.rpcTimeout).thenApply(ExecutionGraphInfo::getArchivedExecutionGraph));
    }

    public CompletableFuture<Collection<JobStatusMessage>> listJobs() {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.requestMultipleJobDetails(this.rpcTimeout).thenApply(jobs -> jobs.getJobs().stream().map(details -> new JobStatusMessage(details.getJobId(), details.getJobName(), details.getStatus(), details.getStartTime())).collect(Collectors.toList())));
    }

    public CompletableFuture<JobStatus> getJobStatus(JobID jobId) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.requestJobStatus(jobId, this.rpcTimeout));
    }

    public CompletableFuture<Acknowledge> cancelJob(JobID jobId) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.cancelJob(jobId, this.rpcTimeout));
    }

    public CompletableFuture<String> triggerSavepoint(JobID jobId, String targetDirectory, boolean cancelJob) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.triggerSavepointAndGetLocation(jobId, targetDirectory, cancelJob ? TriggerSavepointMode.CANCEL_WITH_SAVEPOINT : TriggerSavepointMode.SAVEPOINT, this.rpcTimeout));
    }

    public CompletableFuture<String> triggerCheckpoint(JobID jobID) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.triggerCheckpoint(jobID, this.rpcTimeout));
    }

    public CompletableFuture<String> stopWithSavepoint(JobID jobId, String targetDirectory, boolean terminate) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.stopWithSavepointAndGetLocation(jobId, targetDirectory, terminate ? TriggerSavepointMode.TERMINATE_WITH_SAVEPOINT : TriggerSavepointMode.SUSPEND_WITH_SAVEPOINT, this.rpcTimeout));
    }

    public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.disposeSavepoint(savepointPath, this.rpcTimeout));
    }

    public CompletableFuture<? extends AccessExecutionGraph> getExecutionGraph(JobID jobId) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.requestJob(jobId, this.rpcTimeout));
    }

    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(JobID jobId, OperatorID operatorId, SerializedValue<CoordinationRequest> serializedRequest) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.deliverCoordinationRequestToCoordinator(jobId, operatorId, serializedRequest, this.rpcTimeout));
    }

    private <T> CompletableFuture<T> runDispatcherCommand(Function<DispatcherGateway, CompletableFuture<T>> dispatcherCommand) {
        return ((CompletableFuture)this.getDispatcherGatewayFuture().thenApply(dispatcherCommand)).thenCompose(Function.identity());
    }

    public void runDetached(JobGraph job) throws JobExecutionException, InterruptedException {
        Preconditions.checkNotNull((Object)job, (String)"job is null");
        CompletableFuture<JobSubmissionResult> submissionFuture = this.submitJob(job);
        try {
            submissionFuture.get();
        }
        catch (ExecutionException e) {
            throw new JobExecutionException(job.getJobID(), ExceptionUtils.stripExecutionException((Throwable)e));
        }
    }

    public JobExecutionResult executeJobBlocking(JobGraph job) throws JobExecutionException, InterruptedException {
        JobResult jobResult;
        Preconditions.checkNotNull((Object)job, (String)"job is null");
        CompletableFuture<JobSubmissionResult> submissionFuture = this.submitJob(job);
        CompletionStage jobResultFuture = submissionFuture.thenCompose(ignored -> this.requestJobResult(job.getJobID()));
        try {
            jobResult = (JobResult)((CompletableFuture)jobResultFuture).get();
        }
        catch (ExecutionException e) {
            throw new JobExecutionException(job.getJobID(), "Could not retrieve JobResult.", ExceptionUtils.stripExecutionException((Throwable)e));
        }
        try {
            return jobResult.toJobExecutionResult(Thread.currentThread().getContextClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new JobExecutionException(job.getJobID(), e);
        }
    }

    public CompletableFuture<JobSubmissionResult> submitJob(JobGraph jobGraph) {
        CompletableFuture<DispatcherGateway> dispatcherGatewayFuture = this.getDispatcherGatewayFuture();
        CompletableFuture<InetSocketAddress> blobServerAddressFuture = this.createBlobServerAddress(dispatcherGatewayFuture);
        CompletableFuture<Void> jarUploadFuture = this.uploadAndSetJobFiles(blobServerAddressFuture, jobGraph);
        CompletionStage acknowledgeCompletableFuture = ((CompletableFuture)jarUploadFuture.thenCombine(dispatcherGatewayFuture, (ack, dispatcherGateway) -> dispatcherGateway.submitJob(jobGraph, this.rpcTimeout))).thenCompose(Function.identity());
        return ((CompletableFuture)acknowledgeCompletableFuture).thenApply(ignored -> new JobSubmissionResult(jobGraph.getJobID()));
    }

    public CompletableFuture<JobResult> requestJobResult(JobID jobId) {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.requestJobResult(jobId, RpcUtils.INF_TIMEOUT));
    }

    public CompletableFuture<ClusterOverview> requestClusterOverview() {
        return this.runDispatcherCommand(dispatcherGateway -> dispatcherGateway.requestClusterOverview(RpcUtils.INF_TIMEOUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected CompletableFuture<DispatcherGateway> getDispatcherGatewayFuture() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.running, (Object)"MiniCluster is not yet running or has already been shut down.");
            return this.dispatcherGatewayRetriever.getFuture();
        }
    }

    private CompletableFuture<Void> uploadAndSetJobFiles(CompletableFuture<InetSocketAddress> blobServerAddressFuture, JobGraph job) {
        return blobServerAddressFuture.thenAccept(blobServerAddress -> {
            try {
                ClientUtils.extractAndUploadJobGraphFiles(job, (SupplierWithException<BlobClient, IOException>)((SupplierWithException)() -> new BlobClient((InetSocketAddress)blobServerAddress, (Configuration)this.miniClusterConfiguration.getConfiguration())));
            }
            catch (FlinkException e) {
                throw new CompletionException(e);
            }
        });
    }

    private CompletableFuture<InetSocketAddress> createBlobServerAddress(CompletableFuture<DispatcherGateway> dispatcherGatewayFuture) {
        return ((CompletableFuture)dispatcherGatewayFuture.thenApply(dispatcherGateway -> dispatcherGateway.getBlobServerPort(this.rpcTimeout).thenApply(blobServerPort -> new InetSocketAddress(dispatcherGateway.getHostname(), (int)blobServerPort)))).thenCompose(Function.identity());
    }

    protected MetricRegistryImpl createMetricRegistry(Configuration config, long maximumMessageSizeInBytes) {
        return new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(config, maximumMessageSizeInBytes), ReporterSetup.fromConfiguration(config, null));
    }

    protected RpcService createRemoteRpcService(Configuration configuration, String bindAddress, int bindPort, RpcSystem rpcSystem) throws Exception {
        return rpcSystem.remoteServiceBuilder(configuration, bindAddress, String.valueOf(bindPort)).withBindAddress(bindAddress).withBindPort(bindPort).withExecutorConfiguration(RpcUtils.getTestForkJoinExecutorConfiguration()).createAndStart();
    }

    protected RpcService createRemoteRpcService(Configuration configuration, String externalAddress, String externalPortRange, String bindAddress, RpcSystem rpcSystem) throws Exception {
        return rpcSystem.remoteServiceBuilder(configuration, externalAddress, externalPortRange).withBindAddress(bindAddress).withExecutorConfiguration(RpcUtils.getTestForkJoinExecutorConfiguration()).createAndStart();
    }

    protected RpcService createLocalRpcService(Configuration configuration, RpcSystem rpcSystem) throws Exception {
        return rpcSystem.localServiceBuilder(configuration).withExecutorConfiguration(RpcUtils.getTestForkJoinExecutorConfiguration()).createAndStart();
    }

    @GuardedBy(value="lock")
    private CompletableFuture<Void> shutDownResourceManagerComponents() {
        ArrayList<CompletableFuture<Void>> terminationFutures = new ArrayList<CompletableFuture<Void>>(this.dispatcherResourceManagerComponents.size());
        for (DispatcherResourceManagerComponent dispatcherResourceManagerComponent : this.dispatcherResourceManagerComponents) {
            terminationFutures.add(dispatcherResourceManagerComponent.closeAsync());
        }
        FutureUtils.ConjunctFuture dispatcherTerminationFuture = FutureUtils.completeAll(terminationFutures);
        return FutureUtils.runAfterwards((CompletableFuture)dispatcherTerminationFuture, () -> {
            Exception exception = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.resourceManagerLeaderRetriever != null) {
                    try {
                        this.resourceManagerLeaderRetriever.stop();
                    }
                    catch (Exception e) {
                        exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
                    }
                    this.resourceManagerLeaderRetriever = null;
                }
                if (this.dispatcherLeaderRetriever != null) {
                    try {
                        this.dispatcherLeaderRetriever.stop();
                    }
                    catch (Exception e) {
                        exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                    }
                    this.dispatcherLeaderRetriever = null;
                }
                if (this.clusterRestEndpointLeaderRetrievalService != null) {
                    try {
                        this.clusterRestEndpointLeaderRetrievalService.stop();
                    }
                    catch (Exception e) {
                        exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                    }
                    this.clusterRestEndpointLeaderRetrievalService = null;
                }
            }
            if (exception != null) {
                throw exception;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateMiniClusterServices() throws Exception {
        Exception exception = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.blobCacheService != null) {
                try {
                    this.blobCacheService.close();
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
                }
                this.blobCacheService = null;
            }
            if (this.blobServer != null) {
                try {
                    this.blobServer.close();
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                }
                this.blobServer = null;
            }
            if (this.haServices != null) {
                try {
                    this.haServices.closeAndCleanupAllData();
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                }
                this.haServices = null;
            }
            try {
                this.rpcSystem.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private CompletableFuture<Void> terminateRpcServices() {
        Object object = this.lock;
        synchronized (object) {
            int numRpcServices = 1 + this.rpcServices.size();
            ArrayList<CompletableFuture> rpcTerminationFutures = new ArrayList<CompletableFuture>(numRpcServices);
            rpcTerminationFutures.add(this.commonRpcService.stopService());
            for (RpcService rpcService : this.rpcServices) {
                rpcTerminationFutures.add(rpcService.stopService());
            }
            this.commonRpcService = null;
            this.rpcServices.clear();
            return FutureUtils.completeAll(rpcTerminationFutures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> terminateExecutors(long executorShutdownTimeoutMillis) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ioExecutor != null) {
                return ExecutorUtils.nonBlockingShutdown((long)executorShutdownTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.ioExecutor});
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private void initializeIOFormatClasses(Configuration configuration) {
        FileOutputFormat.initDefaultsFromConfiguration((Configuration)configuration);
    }

    public static enum HaServices {
        CONFIGURED,
        WITH_LEADERSHIP_CONTROL;

    }

    private class TerminatingFatalErrorHandlerFactory {
        private TerminatingFatalErrorHandlerFactory() {
        }

        @GuardedBy(value="lock")
        private TerminatingFatalErrorHandler create(int index) {
            return new TerminatingFatalErrorHandler(index);
        }
    }

    private class ShutDownFatalErrorHandler
    implements FatalErrorHandler {
        private ShutDownFatalErrorHandler() {
        }

        public void onFatalError(Throwable exception) {
            LOG.warn("Error in MiniCluster. Shutting the MiniCluster down.", exception);
            MiniCluster.this.closeAsync();
        }
    }

    private class TerminatingFatalErrorHandler
    implements FatalErrorHandler {
        private final int index;

        private TerminatingFatalErrorHandler(int index) {
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFatalError(Throwable exception) {
            if (MiniCluster.this.running) {
                LOG.error("TaskManager #{} failed.", (Object)this.index, (Object)exception);
                Object object = MiniCluster.this.lock;
                synchronized (object) {
                    ((TaskExecutor)MiniCluster.this.taskManagers.get(this.index)).closeAsync();
                }
            }
        }
    }

    protected class DedicatedRpcServiceFactory
    implements RpcServiceFactory {
        private final Configuration configuration;
        private final String externalAddress;
        private final String externalPortRange;
        private final String bindAddress;
        private final RpcSystem rpcSystem;

        DedicatedRpcServiceFactory(Configuration configuration, String externalAddress, String externalPortRange, String bindAddress, RpcSystem rpcSystem) {
            this.configuration = configuration;
            this.externalAddress = externalAddress;
            this.externalPortRange = externalPortRange;
            this.bindAddress = bindAddress;
            this.rpcSystem = rpcSystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RpcService createRpcService() throws Exception {
            RpcService rpcService = MiniCluster.this.createRemoteRpcService(this.configuration, this.externalAddress, this.externalPortRange, this.bindAddress, this.rpcSystem);
            Object object = MiniCluster.this.lock;
            synchronized (object) {
                MiniCluster.this.rpcServices.add(rpcService);
            }
            return rpcService;
        }
    }

    protected static class CommonRpcServiceFactory
    implements RpcServiceFactory {
        private final RpcService commonRpcService;

        CommonRpcServiceFactory(RpcService commonRpcService) {
            this.commonRpcService = commonRpcService;
        }

        @Override
        public RpcService createRpcService() {
            return this.commonRpcService;
        }
    }

    protected static interface RpcServiceFactory {
        public RpcService createRpcService() throws Exception;
    }
}

