/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.resourcemanager.AbstractResourceManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.ThreadDumpInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskManagerThreadDumpHandler
extends AbstractResourceManagerHandler<RestfulGateway, EmptyRequestBody, ThreadDumpInfo, TaskManagerMessageParameters> {
    public TaskManagerThreadDumpHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, ThreadDumpInfo, TaskManagerMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<ThreadDumpInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ResourceID taskManagerId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        return gateway.requestThreadDump(taskManagerId, this.timeout);
    }
}

