/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.FileExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.shaded.guava30.com.google.common.base.Ticker;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.Preconditions;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class ExecutionGraphInfoStoreTestUtils {
    static final List<JobStatus> GLOBALLY_TERMINAL_JOB_STATUS = Arrays.stream(JobStatus.values()).filter(JobStatus::isGloballyTerminalState).collect(Collectors.toList());

    static Collection<ExecutionGraphInfo> generateTerminalExecutionGraphInfos(int number) {
        ArrayList<ExecutionGraphInfo> executionGraphInfos = new ArrayList<ExecutionGraphInfo>(number);
        for (int i = 0; i < number; ++i) {
            JobStatus state = GLOBALLY_TERMINAL_JOB_STATUS.get(ThreadLocalRandom.current().nextInt(GLOBALLY_TERMINAL_JOB_STATUS.size()));
            executionGraphInfos.add(new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(state).build()));
        }
        return executionGraphInfos;
    }

    static Collection<JobDetails> generateJobDetails(Collection<ExecutionGraphInfo> executionGraphInfos) {
        return executionGraphInfos.stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(JobDetails::createDetailsForJob).collect(Collectors.toList());
    }

    static FileExecutionGraphInfoStore createDefaultExecutionGraphInfoStore(File storageDirectory) throws IOException {
        return new FileExecutionGraphInfoStore(storageDirectory, Time.hours((long)1L), Integer.MAX_VALUE, 10000L, TestingUtils.defaultScheduledExecutor(), Ticker.systemTicker());
    }

    static class PersistingMiniCluster
    extends MiniCluster {
        @Nullable
        private final File rootDir;

        PersistingMiniCluster(MiniClusterConfiguration miniClusterConfiguration) {
            this(miniClusterConfiguration, null);
        }

        PersistingMiniCluster(MiniClusterConfiguration miniClusterConfiguration, @Nullable File rootDir) {
            super(miniClusterConfiguration);
            this.rootDir = rootDir;
        }

        protected Collection<? extends DispatcherResourceManagerComponent> createDispatcherResourceManagerComponents(Configuration configuration, MiniCluster.RpcServiceFactory rpcServiceFactory, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, MetricQueryServiceRetriever metricQueryServiceRetriever, FatalErrorHandler fatalErrorHandler) throws Exception {
            FileExecutionGraphInfoStore executionGraphInfoStore;
            DefaultDispatcherResourceManagerComponentFactory dispatcherResourceManagerComponentFactory = DefaultDispatcherResourceManagerComponentFactory.createSessionComponentFactory((ResourceManagerFactory)StandaloneResourceManagerFactory.getInstance());
            JobManagerOptions.JobStoreType jobStoreType = (JobManagerOptions.JobStoreType)configuration.get(JobManagerOptions.JOB_STORE_TYPE);
            switch (jobStoreType) {
                case File: {
                    executionGraphInfoStore = ExecutionGraphInfoStoreTestUtils.createDefaultExecutionGraphInfoStore(this.rootDir);
                    break;
                }
                case Memory: {
                    executionGraphInfoStore = new MemoryExecutionGraphInfoStore();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported job store type " + jobStoreType);
                }
            }
            return Collections.singleton(dispatcherResourceManagerComponentFactory.create(configuration, ResourceID.generate(), this.getIOExecutor(), rpcServiceFactory.createRpcService(), this.getHaServices(), blobServer, heartbeatServices, metricRegistry, (ExecutionGraphInfoStore)executionGraphInfoStore, metricQueryServiceRetriever, fatalErrorHandler));
        }
    }

    public static class SignallingBlockingNoOpInvokable
    extends AbstractInvokable {
        public static final OneShotLatch LATCH = new OneShotLatch();

        public SignallingBlockingNoOpInvokable(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            LATCH.trigger();
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    static final class PartialExecutionGraphInfoMatcher
    extends BaseMatcher<ExecutionGraphInfo> {
        private final ExecutionGraphInfo expectedExecutionGraphInfo;

        PartialExecutionGraphInfoMatcher(ExecutionGraphInfo expectedExecutionGraphInfo) {
            this.expectedExecutionGraphInfo = (ExecutionGraphInfo)Preconditions.checkNotNull((Object)expectedExecutionGraphInfo);
        }

        public boolean matches(Object o) {
            if (this.expectedExecutionGraphInfo == o) {
                return true;
            }
            if (o == null || this.expectedExecutionGraphInfo.getClass() != o.getClass()) {
                return false;
            }
            ExecutionGraphInfo that = (ExecutionGraphInfo)o;
            ArchivedExecutionGraph thisExecutionGraph = this.expectedExecutionGraphInfo.getArchivedExecutionGraph();
            ArchivedExecutionGraph thatExecutionGraph = that.getArchivedExecutionGraph();
            return thisExecutionGraph.isStoppable() == thatExecutionGraph.isStoppable() && Objects.equals(thisExecutionGraph.getJobID(), thatExecutionGraph.getJobID()) && Objects.equals(thisExecutionGraph.getJobName(), thatExecutionGraph.getJobName()) && thisExecutionGraph.getState() == thatExecutionGraph.getState() && Objects.equals(thisExecutionGraph.getJsonPlan(), thatExecutionGraph.getJsonPlan()) && Objects.equals(thisExecutionGraph.getAccumulatorsSerialized(), thatExecutionGraph.getAccumulatorsSerialized()) && Objects.equals(thisExecutionGraph.getCheckpointCoordinatorConfiguration(), thatExecutionGraph.getCheckpointCoordinatorConfiguration()) && thisExecutionGraph.getAllVertices().size() == thatExecutionGraph.getAllVertices().size() && Objects.equals(this.expectedExecutionGraphInfo.getExceptionHistory(), that.getExceptionHistory());
        }

        public void describeTo(Description description) {
            description.appendText("Matches against " + ExecutionGraphInfo.class.getSimpleName() + '.');
        }
    }
}

